% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{collapse}
\alias{collapse}
\title{Paste and collapse.}
\usage{
collapse(..., inter = "")
}
\arguments{
\item{...}{Objects to be pasted and collapsed.}

\item{inter}{[character] String with which to intersperse the result. Defaults to an empty string.}
}
\value{
[character] The collapsed string.
}
\description{
Concatenate strings, possibly interspersing them with another string.
}
\details{
\code{paste0(..., collapse="")} takes a little more space than \code{collapse(...)}, though if the result is to be interspersed with something, the difference becomes merely one character: \code{paste0(..., collapse="_")} vs \code{collapse(..., inter="_")}.
}
\examples{
tmp <- c ("i", "am", "a", "sample", "vector")
identical (soundcorrs:::collapse(tmp), paste0(tmp,collapse=""))
}
\keyword{internal}
