% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transcription.R
\name{expandMeta}
\alias{expandMeta}
\title{Expand custom metacharacters to regular expressions.}
\usage{
expandMeta(data, x)
}
\arguments{
\item{data}{[transcription] The \code{\link{transcription}} to use.}

\item{x}{[character] A single string that contains metacharacters.}
}
\value{
[character] The string with metacharacters expanded.
}
\description{
Turn characters defined in a \code{\link{transcription}} as metacharacters into the corresponding regular expression.
}
\examples{
dataset <- loadSampleDataset ("data-abc")
expandMeta (dataset$trans[[1]], "aN")
expandMeta (dataset$trans[[1]], "[+vow,-high]")
}
\seealso{
\code{\link{transcription}}
}
