% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{print.list.applyChanges}
\alias{print.list.applyChanges}
\title{Pretty printing for the result of \code{\link{applyChanges}}.}
\usage{
\method{print}{list.applyChanges}(x, ...)
}
\arguments{
\item{x}{[list.applyChanges] The output of \code{\link{applyChanges}}.}

\item{...}{Unused; only for consistency with \code{\link{print}}.}
}
\value{
[list.applyChanges] The same object that was given as \code{x}.
}
\description{
Pretty printing for the result of \code{\link{applyChanges}}.
}
\details{
The output of \code{\link{applyChanges}} is a list, potentially a very long one, and difficult to read. To make it easier to digest, this function only prints the \code{$end} element, i.e. the final shapes produced by the application of all of the sound changes.
}
\examples{
# prepare sample transcription
trans <- loadSampleDataset ("trans-common")
# define sound changes
a2b <- soundchange ("a > b", "change 1", trans)
b2c <- soundchange ("b > c", "change 2", trans)
# and apply them
applyChanges (c("a","b","c"), list(a2b,b2c))
}
\seealso{
\code{\link{applyChanges}}, \code{\link{print.tree.applyChanges}}
}
