% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{binTable}
\alias{binTable}
\title{Sum all rows and all columns in a table, except for the selected ones.}
\usage{
binTable(x, row, col)
}
\arguments{
\item{x}{[data.frame/matrix/table] Table to be binned.}

\item{row}{[integer/vector] The rows to not be binned.}

\item{col}{[integer/vector] The columns to not be binned.}
}
\value{
[table] Table with some of its data binned.
}
\description{
Useful for when the data are scarce and \code{\link{chisq.test}} returns a warning, or when a more specific analysis of the data is required.
}
\details{
When working with sparse data, the absolute values in a table are sometimes too low to allow for the use of various statistical tests, or the features too numerous for the result of a statistical test to be clearly interpretable. In such cases, a solution may be found in binning, i.e. in combining all the rows or columns into one, with the exception of select few. For example, a 10x10 table may be thus reduced to a 2x2 or a 2x3 one. The values are magnified while the number of features is reduced.
}
\examples{
mtx <- matrix (1:16, nrow=4, dimnames=list(paste0("r",1:4),paste0("c",1:4)))
binTable (mtx, 1, 1)
binTable (mtx, 1, c(1,3))
}
