% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.glmsmurf}
\alias{predict.glmsmurf}
\title{Predictions Using Estimated Model}
\usage{
\method{predict}{glmsmurf}(object, newdata = NULL, newoffset = NULL,
  type = c("link", "response", "terms"), ...)
}
\arguments{
\item{object}{An object of class '\code{\link[=glmsmurf-class]{glmsmurf}}', typically the result of a call to \code{\link{glmsmurf}} or \code{\link{glmsmurf.fit}}.}

\item{newdata}{Optionally, a data frame containing the predictors used in the prediction. 
This can only be used when \code{object} contains a formula. 
When \code{newdata} is omitted, the predictions are based on the data used to fit the model in \code{object}.}

\item{newoffset}{Optionally, a vector containing a new offset to be used in the prediction.
When \code{newoffset} is omitted, the predictions use the offset which was used to fit the model in \code{object}.}

\item{type}{Type of prediction. The default is on the scale of the linear predictors (\code{"link"}).
Another option is on the scale of the response variable (\code{"response"}). 
For type \code{"terms"} a matrix containing the fitted values of each term in the model, on the linear predictor scale, is returned.}

\item{...}{Additional arguments which are currently ignored.}
}
\value{
A vector containing the predicted values using the estimated model in \code{object}.
}
\description{
Function to obtain predictions using the estimated model.
}
\examples{
## See example(glmsmurf) for examples
         
}
\seealso{
\code{\link{predict_reest}}, \code{\link[stats]{predict.glm}}, \code{\link[stats]{predict}}, 
         \code{\link{glmsmurf}}, \code{\link{glmsmurf-class}}
}
