% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/circles.intersect.R
\name{circles.intersect}
\alias{circles.intersect}
\title{Determine whether circles intersection}
\usage{
circles.intersect(coords, r)
}
\arguments{
\item{coords}{A matrix of coordinates containined the centroid of each circle.}

\item{r}{A vector containing the radii of the circles.  The have length equal to the number of rows of
\code{coords}.}
}
\value{
Returns a matrix of logical values indicating whether the circles intersect.
}
\description{
\code{circles.intersect} determines whether circles intersect with each other.
}
\details{
The algorithm is based on the premise that two circles intersect if, and only if, the distance between their centroids is between the sum and the difference of their radii.  I have squared the respective parts of the inequality in the implemented algorithm.
}
\examples{
# first two intersect, then next two, last doesn't intersect any other
co = cbind(c(1, 2, 5, 6, 9), c(1, 2, 5, 6, 9))
r = c(1.25, 1.25, 1.25, 1.25, 1.25)
circles.intersect(co, r)
# nested circles
co = matrix(rep(0, 4), nrow = 2)
r = c(1, 1.5)
circles.intersect(co, r)
}
\author{
Joshua French
}

