% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-analysis.R
\name{curvigram}
\alias{curvigram}
\title{Computes declination curvigram}
\usage{
curvigram(dec, unc = 2, norm = F, cut = 4, range, n = 512)
}
\arguments{
\item{dec}{Array of declination values}

\item{unc}{(Optional) Either a single value or string to be applied
to all measurements (see \code{\link{bw.nrd}}), or an
array of values of the same length as \emph{dec}. Defaults
to 2 degrees.}

\item{norm}{(Optional) Boolean specifying whether the resulting curvigram
should be normalized to unity. Defaults to \emph{FALSE}.}

\item{cut}{(Optional) Number of uncertainties beyond the extremes
of the data at which to trim the curvigram. Defaults to 4. See \code{\link{density}}.}

\item{range}{(Optional) As an alternative to \emph{cut} you can
stipulate the range of declination values to output as an array of two values.
See \emph{from, to} in \code{\link{density}}.}

\item{n}{(Optional) The number of equally spaced points at which the curvigram
is to be calculated. Defaults to 512. See \emph{n} in \code{\link{density}}.}
}
\description{
This function computes the curvigram of declinations,
using provided measurement uncertainty and a Gaussian
kernel, i.e. using the method of Silva (2017). When all
measurements have the same associated
uncertainty this function wraps \code{\link{density}} and
accepts the same input for \emph{bw} in \emph{unc}.
}
\examples{
# Curvigram of Ruggles' Recumbent Stone Circle data:
data(RugglesRSC)
curv <- curvigram(RugglesRSC$Dec, 2)
plotCurv(curv)
}
\references{
Silva, Fabio (2017) Inferring Alignments I: Exploring the Accuracy
and Precision of Two Statistical Approaches, \emph{Journal of Skyscape Archaeology}
3(1), 93-111. DOI: 10.1558/jsa.31958
}
\seealso{
\code{\link{density}}
}
