% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/haystack_IO.R
\name{read_haystack}
\alias{read_haystack}
\title{Function to read haystack results from file.}
\usage{
read_haystack(file)
}
\arguments{
\item{file}{A file containing 'haystack' results to read}
}
\value{
An object of class "haystack"
}
\description{
Function to read haystack results from file.
}
\examples{
# using the toy example of the singleCellHaystack package
# define a logical matrix with detection of each gene (rows) in each cell (columns)
dat.detection <- dat.expression > 1

# running haystack in default mode
res <- haystack(dat.tsne, detection=dat.detection, method = "2D")

outfile <- file.path(tempdir(), "output.csv")

# write result to file outfile.csv
write_haystack(res, file = outfile)

# read in result from file
res.copy <- read_haystack(file = outfile)
}
