% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/noverlap.R
\name{sg_noverlap}
\alias{sg_noverlap}
\alias{sg_noverlap_p}
\title{No overlap}
\usage{
sg_noverlap(sg, ...)

sg_noverlap_p(proxy, nodeMargin = 5, ...)
}
\arguments{
\item{sg}{An object of class \code{sigmajs}as intatiated by \code{\link{sigmajs}}.}

\item{...}{any option to pass to the plugin, see \href{https://github.com/jacomyal/sigma.js/tree/master/plugins/sigma.layout.noverlap}{official documentation}.}

\item{proxy}{An object of class \code{sigmajsProxy} as returned by \code{\link{sigmajsProxy}}.}

\item{nodeMargin}{The additional minimum space to apply around each and every node.}
}
\description{
This plugin runs an algorithm which distributes nodes in the network, ensuring that they do not overlap and providing a margin where specified.
}
\examples{
nodes <- sg_make_nodes(500)
edges <- sg_make_edges(nodes)

sigmajs() \%>\%
  sg_nodes(nodes, id, size, color) \%>\%
  sg_edges(edges, id, source, target) \%>\%
  sg_layout() \%>\% 
  sg_noverlap()

}
