% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateFigures.R
\name{printInfectionCurves}
\alias{printInfectionCurves}
\title{Prints infection curves.}
\usage{
printInfectionCurves(dataInput, sigmoidalFitVector = NULL,
  doubleSigmoidalFitVector = NULL, showParameterRelatedLines = FALSE,
  xlabelText = "time", ylabelText = "intensity")
}
\arguments{
\item{dataInput}{a data frame composed of two columns. One is for time and the other is for intensity. Should be normalized data generated by normalizeData function.}

\item{sigmoidalFitVector}{the output of sigmoidalFitFunction. Default is NULL.}

\item{doubleSigmoidalFitVector}{the output of double sigmoidal fit function. Default is NULL.}

\item{showParameterRelatedLines}{if equal to TRUE, figure will show parameter related lines on the curves. Default is FALSE.}

\item{xlabelText}{the x-axis name; with default "time"}

\item{ylabelText}{the y-axis name; with default "intensity"}
}
\value{
Returns infection curve figures.
}
\description{
Generates figures using ggplot that shows the input data and the fitted curves.
}
\examples{
time=seq(3,24,0.1)

#simulate intensity data and add noise
noise_parameter=0.2
intensity_noise=runif(n = length(time),min = 0,max = 1)*noise_parameter
intensity=doublesigmoidalFitFormula(time,
                                   finalAsymptoteIntensity=.3,
                                   maximum=4,
                                   slope1=1,
                                   midPoint1=7,
                                   slope2=1,
                                   midPointDistance=8)
intensity=intensity+intensity_noise

dataInput=data.frame(intensity=intensity,time=time)
normalizedInput = normalizeData(dataInput,dataInputName="batch_01_21_2016_samp007623")


# Do the double sigmoidal fit
doubleSigmoidalModel=fitFunction(dataInput=normalizedInput,
                                          model="doublesigmoidal",
                                          n_runs_min=20,
                                          n_runs_max=500,
                                          showDetails=FALSE)

doubleSigmoidalModel = numericalReCalculation(doubleSigmoidalModel,
                                                       stepSize=0.00001)

fig01=printInfectionCurves(dataInput=normalizedInput,
                          doubleSigmoidalFitVector=doubleSigmoidalModel,
                          showParameterRelatedLines=TRUE)
print(fig01)


}

