% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/approach_vaeac.R
\name{vaeac_check_which_vaeac_model}
\alias{vaeac_check_which_vaeac_model}
\title{Function that checks for valid \code{vaeac} model name}
\usage{
vaeac_check_which_vaeac_model(
  which_vaeac_model,
  epochs,
  save_every_nth_epoch = NULL
)
}
\arguments{
\item{which_vaeac_model}{String (default is \code{best}). The name of the \code{vaeac} model (snapshots from different
epochs) to use when generating the Monte Carlo samples. The standard choices are: \code{"best"} (epoch with lowest IWAE),
\code{"best_running"} (epoch with lowest running IWAE, see \code{vaeac.running_avg_n_values}), and \code{last} (the last epoch).
Note that additional choices are available if \code{vaeac.save_every_nth_epoch} is provided. For example, if
\code{vaeac.save_every_nth_epoch = 5}, then \code{vaeac.which_vaeac_model} can also take the values \code{"epoch_5"}, \code{"epoch_10"},
\code{"epoch_15"}, and so on.}

\item{epochs}{Positive integer (default is \code{100}). The number of epochs to train the final vaeac model.
This includes \code{epochs_initiation_phase}, where the default is \code{2}.}

\item{save_every_nth_epoch}{Positive integer (default is \code{NULL}). If provided, then the vaeac model after
every \code{save_every_nth_epoch}th epoch will be saved.}
}
\value{
The function does not return anything.
}
\description{
Function that checks for valid \code{vaeac} model name
}
\author{
Lars Henry Berge Olsen
}
\keyword{internal}
