% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initGMF-class.R
\name{coefficients.initgmf}
\alias{coefficients.initgmf}
\alias{coef.initgmf}
\title{Extract the coefficient of an initialized GMF model}
\usage{
\method{coefficients}{initgmf}(
  object,
  ...,
  type = c("all", "colreg", "rowreg", "scores", "loadings")
)

\method{coef}{initgmf}(object, ..., type = c("all", "colreg", "rowreg", "scores", "loadings"))
}
\arguments{
\item{object}{an object of class \code{initgmf}}

\item{...}{further arguments passed to or from other methods}

\item{type}{the type of coefficients which should be returned}
}
\value{
If \code{type="all"}, a list of coefficients containing the fields \code{B}, \code{A}, \code{U} and \code{V}.
Otherwise, a matrix of coefficients, corresponding to the selected \code{type}.
}
\description{
Return the initialized coefficients of a GMF model, i.e., the row- and column-specific
regression effects, the latent scores and loadings.
}
\examples{
# Load the sgdGMF package
library(sgdGMF)

# Generate data from a Poisson model
data = sim.gmf.data(n = 100, m = 20, ncomp = 5, family = poisson())

# Fit a GMF model with 3 latent factors
init = sgdgmf.init(data$Y, ncomp = 3, family = poisson())

# Get the estimated coefficients of a GMF model
str(coefficients(init)) # returns all the coefficients
str(coefficients(init, type = "scores")) # returns only the scores, say U
str(coefficients(init, type = "loadings")) # returns only the loadings, say V

}
\seealso{
\code{\link{coefficients.sgdgmf}} and \code{\link{coef.sgdgmf}}.
}
