% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{sim.gmf.data}
\alias{sim.gmf.data}
\title{Simulate non-Gaussian data from a GMF model}
\usage{
sim.gmf.data(n = 100, m = 20, ncomp = 5, family = gaussian(), dispersion = 1)
}
\arguments{
\item{n}{number of observations}

\item{m}{number of variables}

\item{ncomp}{rank of the latent matrix factorization}

\item{family}{a \code{glm} family (see \code{\link{family}} for more details)}

\item{dispersion}{a positive dispersion parameter}
}
\value{
A list containing the following objects:
\itemize{
  \item \code{Y}: simulated response matrix
  \item \code{U}: simulated factor matrix
  \item \code{V}: simulated loading matrix
  \item \code{eta}: linear predictor matrix
  \item \code{mu}: conditional mean matrix
  \item \code{phi}: scalar dispersion parameter
  \item \code{family}: model family
  \item \code{ncomp}: rank of the latent matrix factorization
  \item \code{param}: a list containing time, phase, frequency and amplitude vectors used to generate \code{U}
}
}
\description{
Simulate synthetic non-Gaussian data from a generalized matrix factorization (GMF) model.
}
\details{
The loadings, \code{V}, are independently sampled from a standard normal distribution.
The scores, \code{U}, are simulated according to sinusoidal signals evaluated at different
phases, frequencies and amplitudes. These parameters are randomly sampled from independent
uniform distributions.
}
\examples{
library(sgdGMF)

# Set the data dimensions
n = 100; m = 20; d = 5

# Generate data using Poisson, Binomial and Gamma models
data_pois = sim.gmf.data(n = n, m = m, ncomp = d, family = poisson())
data_bin = sim.gmf.data(n = n, m = m, ncomp = d, family = binomial())
data_gam = sim.gmf.data(n = n, m = m, ncomp = d, family = Gamma(link = "log"), dispersion = 0.25)

# Compare the results
oldpar = par(no.readonly = TRUE)
par(mfrow = c(3,3), mar = c(1,1,3,1))
image(data_pois$Y, axes = FALSE, main = expression(Y[Pois]))
image(data_pois$mu, axes = FALSE, main = expression(mu[Pois]))
image(data_pois$U, axes = FALSE, main = expression(U[Pois]))
image(data_bin$Y, axes = FALSE, main = expression(Y[Bin]))
image(data_bin$mu, axes = FALSE, main = expression(mu[Bin]))
image(data_bin$U, axes = FALSE, main = expression(U[Bin]))
image(data_gam$Y, axes = FALSE, main = expression(Y[Gam]))
image(data_gam$mu, axes = FALSE, main = expression(mu[Gam]))
image(data_gam$U, axes = FALSE, main = expression(U[Gam]))
par(oldpar)

}
