% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.seroincidence.R
\name{print.seroincidence}
\alias{print.seroincidence}
\title{Print Method for \code{seroincidence} Class}
\usage{
\method{print}{seroincidence}(x, ...)
}
\arguments{
\item{x}{A list containing output of function \code{\link[=est_seroincidence]{est_seroincidence()}}.}

\item{...}{Additional arguments affecting the summary produced.}
}
\value{
an \link{invisible} copy of input parameter \code{x}
}
\description{
\code{\link[=print]{print()}} function for \code{seroincidence} objects from \code{\link[=est_seroincidence]{est_seroincidence()}}
}
\examples{
library(dplyr)

xs_data <-
  sees_pop_data_pk_100

curve <-
  typhoid_curves_nostrat_100 \%>\%
  filter(antigen_iso \%in\% c("HlyE_IgA", "HlyE_IgG"))

noise <-
  example_noise_params_pk

est1 <- est_seroincidence(
  pop_data = xs_data,
  sr_params = curve,
  noise_params = noise,
  antigen_isos = c("HlyE_IgG", "HlyE_IgA"),
)
print(est1)

}
\keyword{internal}
