% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_sr_params.R
\name{as_sr_params}
\alias{as_sr_params}
\title{Load longitudinal seroresponse parameters}
\usage{
as_sr_params(data, antigen_isos = NULL)
}
\arguments{
\item{data}{a \code{\link[=data.frame]{data.frame()}} or \link[tibble:tbl_df-class]{tibble::tbl_df}}

\item{antigen_isos}{a \code{\link[=character]{character()}} vector of antigen isotypes
to be used in analyses}
}
\value{
a \code{curve_data} object
(a \link[tibble:tbl_df-class]{tibble::tbl_df} with extra attribute \code{antigen_isos})
}
\description{
Load longitudinal seroresponse parameters
}
\examples{
library(magrittr)
curve_data <-
  serocalculator_example("example_curve_params.csv") \%>\%
  read.csv() \%>\%
  as_curve_params()

print(curve_data)
}
