% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inspect_mmMatrix.R
\name{as.reflective.measurement_model}
\alias{as.reflective.measurement_model}
\title{Converts all contructs of a measurement model, or just a single construct
 into reflective factors.}
\usage{
\method{as.reflective}{measurement_model}(x, ...)
}
\arguments{
\item{x}{A measurement model defined by \code{\link{constructs}}
or a single composite construct defined by \code{\link{composite}}}

\item{...}{Any further parameters for the specific construct.}
}
\description{
Converts all contructs of a measurement model, or just a single construct
 into reflective factors.
}
\examples{

mobi_mm <- constructs(
  composite("Image",        multi_items("IMAG", 1:5)),
  composite("Expectation",  multi_items("CUEX", 1:3)),
  composite("Value",        multi_items("PERV", 1:2))
)

new_mm <- as.reflective(mobi_mm)

}
\seealso{
\code{\link{as.reflective.construct}}
}
