% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/garch.seg.R
\docType{methods}
\name{garch.seg-class}
\alias{garch.seg-class}
\alias{garch.seg}
\alias{garch.seg-methods}
\alias{garch.seg,ANY-method}
\title{An S4 method to detect the change-points in a high-dimensional GARCH process.}
\usage{
garch.seg(x, p = 1, q = 1, f = 8, sig.level = 0.05, Bsim = 200,
  off.diag = TRUE, dw = NULL, do.pp = TRUE, do.parallel = TRUE)

\S4method{garch.seg}{ANY}(x, p = 1, q = 1, f = 8, sig.level = 0.05,
  Bsim = 200, off.diag = TRUE, dw = NULL, do.pp = TRUE,
  do.parallel = TRUE)
}
\arguments{
\item{x}{Input data matrix, with each row representing the component time series.}

\item{p}{Choose the ARCH order. Default is 1.}

\item{q}{Choose the GARCH order. Default is 1.}

\item{f}{The dampening factor. Default is 8.}

\item{sig.level}{Indicates the quantile of bootstrap test statistics to be used for threshold selection. Default is 0.05.}

\item{Bsim}{Number of bootstrap samples for threshold selection. Default is 200.}

\item{off.diag}{If \code{TRUE} allows to look at the cross-sectional correlation structure.}

\item{dw}{The length of boundaries to be trimmed off.}

\item{do.pp}{Allows further post processing of the estimated change-points to reduce the risk of undersegmentation.}

\item{do.parallel}{Number of copies of R running in parallel, if \code{do.parallel = 0}, \%do\% operator is used, see also \link{foreach}.}
}
\description{
An S4 method to detect the change-points in a high-dimensional GARCH process using the DCBS methodology described in Cho and Korkas (2018).
}
\examples{
#pw.CCC.obj <- new("simMGarch")
#pw.CCC.obj@d=10
#pw.CCC.obj@n=1000
#pw.CCC.obj@changepoints=c(250,750)
#pw.CCC.obj <- pc_cccsim(pw.CCC.obj)
#dcs.obj=garch.seg(pw.CCC.obj@y)
#dcs.obj$est.cps
}
\references{
Cho, Haeran, and Karolos Korkas. "High-dimensional GARCH process segmentation with an application to Value-at-Risk." arXiv preprint arXiv:1706.01155 (2018).
}
