% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aalen_johansen.R
\name{aalen_johansen}
\alias{aalen_johansen}
\title{Aalen Johansen Estimator}
\usage{
aalen_johansen(data, ce, tau)
}
\arguments{
\item{data}{(\code{data.frame})\cr with columns including
\itemize{
\item \code{time_to_event}: Time to the first AE, death or soft competing event.
\item \code{type_of_event}: 0 for censored, 1 for AE, 2 for death, 3 for soft competing event.
}}

\item{ce}{(\code{number})\cr code for competing event.}

\item{tau}{(\code{number})\cr milestone at which Aalen-Johansen is computed.}
}
\value{
(\code{vector})\cr with the following entries:
\itemize{
\item \code{ae_prob}: Estimated probability of AE.
\item \code{ae_prob_var}: Variance of that estimate.
\item \code{ce_prob}: Estimated probability of competing events.
\item \code{ce_prob_var}: Variance of competing events.
}
}
\description{
This function calculates the Aalen Johansen estimator of
adverse events  observed in \verb{[0, tau]}.
Please also refer to  \insertCite{stegherr_estimating_2021;textual}{savvyr}.
}
\examples{
set.seed(123)
dat <- generate_data(n = 5, cens = c(2, 5), haz_ae = 2, haz_death = 3, haz_soft = 5)
aalen_johansen(dat, ce = 2, tau = 4)
}
\references{
\insertRef{stegherr_estimating_2021}{savvyr}
}
