% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convSC2Rad.R
\docType{methods}
\name{convSC2Rad}
\alias{convSC2Rad}
\alias{convSC2Rad,Satellite-method}
\alias{convSC2Rad,RasterStack-method}
\alias{convSC2Rad,RasterLayer-method}
\title{Convert a band's scaled counts to radiance}
\usage{
\S4method{convSC2Rad}{Satellite}(x, szen_correction = "TRUE",
  subset = FALSE)

\S4method{convSC2Rad}{RasterStack}(x, mult, add, szen)

\S4method{convSC2Rad}{RasterLayer}(x, mult, add, szen)
}
\arguments{
\item{x}{An object of class Satellite, raster::RasterStack or 
raster::RasterLayer providing scaled counts (DNs).}

\item{szen_correction}{Logical; if \code{TRUE}, sun zenith correction is 
being applied.}

\item{subset}{Logical; if \code{TRUE}, all layers but the cropped 
ones are being dropped; if \code{FALSE} (default), cropped layers are appended to the 
Satellite object.}

\item{mult}{Multiplicative coefficient for value transformation (i.e. slope).}

\item{add}{Additive coefficient for value transformation (i.e. offset).}

\item{szen}{Cosine of solar zenith angle.}
}
\value{
If x is a Satellite object, a Satellite object with added converted 
layers; \cr
if x is a \code{raster::Raster*} object, a \code{raster::Raster*} object with
converted layer(s).
}
\description{
Convert a band's scaled counts to radiance using a simple linear conversion 
without any kind of atmospheric correction etc.
}
\details{
The conversion functions are taken from USGS' Landsat 8 manual
which is available online at 
\url{http://landsat.usgs.gov/Landsat8_Using_Product.php}.
}
\examples{
path <- system.file("extdata", package = "satellite")
files <- list.files(path, pattern = glob2rx("LC08*.TIF"), full.names = TRUE)
sat <- satellite(files)  
sat <- convSC2Rad(sat)

# If you use a raster layer, supply required meta information
bcde <- "B002n"
convSC2Rad(x = getSatDataLayer(sat, bcde),
           mult = getSatRADM(sat, bcde),
           add = getSatRADA(sat, bcde))

}
\seealso{
\code{\link{calcAtmosCorr}} for conversions of scaled counts 
to physical units including a scene-based atmospheric correction.
}
