% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/start_worker.R
\name{start_worker}
\alias{start_worker}
\title{Start a worker}
\usage{
start_worker(
  worker_id = NULL,
  network_id,
  config = NULL,
  remote = TRUE,
  lgr_thresholds = NULL,
  lgr_buffer_size = 0,
  heartbeat_period = NULL,
  heartbeat_expire = NULL,
  message_log = NULL,
  output_log = NULL
)
}
\arguments{
\item{worker_id}{(\code{character(1)})\cr
Identifier of the worker.
Keys in redis specific to the worker are prefixed with the worker id.}

\item{network_id}{(\code{character(1)})\cr
Identifier of the rush network.
Controller and workers must have the same instance id.
Keys in Redis are prefixed with the instance id.}

\item{config}{(\code{list()})\cr
Configuration for the Redis connection.}

\item{remote}{(\code{logical(1)})\cr
Whether the worker is on a remote machine.}

\item{lgr_thresholds}{(named \code{character()} | named \code{numeric()})\cr
Logger threshold on the workers e.g. \code{c("mlr3/rush" = "debug")}.}

\item{lgr_buffer_size}{(\code{integer(1)})\cr
By default (\code{lgr_buffer_size = 0}), the log messages are directly saved in the Redis data store.
If \code{lgr_buffer_size > 0}, the log messages are buffered and saved in the Redis data store when the buffer is full.
This improves the performance of the logging.}

\item{heartbeat_period}{(\code{integer(1)})\cr
Period of the heartbeat in seconds.
The heartbeat is updated every \code{heartbeat_period} seconds.}

\item{heartbeat_expire}{(\code{integer(1)})\cr
Time to live of the heartbeat in seconds.
The heartbeat key is set to expire after \code{heartbeat_expire} seconds.}

\item{message_log}{(\code{character(1)})\cr
Path to the message log files e.g. \verb{/tmp/message_logs/}
The message log files are named \verb{message_<worker_id>.log}.
If \code{NULL}, no messages, warnings or errors are stored.}

\item{output_log}{(\code{character(1)})\cr
Path to the output log files e.g. \verb{/tmp/output_logs/}
The output log files are named \verb{output_<worker_id>.log}.
If \code{NULL}, no output is stored.}
}
\value{
\code{NULL}
}
\description{
Starts a worker.
The function loads the globals and packages, initializes the \link{RushWorker} instance and invokes the worker loop.
This function is called by \verb{$start_local_workers()} or by the user after creating the worker script with \verb{$create_worker_script()}.
Use with caution.
The global environment is changed.
}
\note{
The function initializes the connection to the Redis data base.
It loads the packages and copies the globals to the global environment of the worker.
The function initialize the \link{RushWorker} instance and starts the worker loop.
}
\examples{
# This example is not executed since Redis must be installed
\dontrun{
  rush::start_worker(
   network_id = 'test-rush',
   remote = TRUE,
   url = 'redis://127.0.0.1:6379',
   scheme = 'redis',
   host = '127.0.0.1',
   port = '6379')
}
}
