% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/score_ibd.R
\name{ibd.length}
\alias{ibd.length}
\title{Score IBD length.}
\usage{
ibd.length(inher.hap1, inher.hap2, startpos = NULL, endpos = NULL)
}
\arguments{
\item{inher.hap1, inher.hap2}{numeric matrix.}

\item{startpos, endpos}{non-negative number.}
}
\value{
A non-negative number representing the length of IBD segment in Haldane centiMorgan.
}
\description{
\code{ibd.length} returns the total length of IBD segemnt between two haplotypes.
}
\details{
This function works with output from \code{\link{sim.recomb}}.
}
\examples{
# a simple pedigree with sibling marriage
pedigree = as.character(rep(1, 5))
member = as.character(c(11, 12, 21, 22, 31))
sex = as.numeric(c(1, 2, 1, 2, 1))
father = as.character(c(NA, NA, 11, 11, 21))
mother = as.character(c(NA, NA, 12, 12, 22))
pedinfo = data.frame(pedigree, member, sex, father, mother, stringsAsFactors = FALSE)
inheritance = sim.recomb(pedinfo, 100)

# IBD length between the two haplotypes of inbred individual 31
ibd.length(inheritance[[9]], inheritance[[10]])
}
