% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgGetBoundary.R
\name{pgGetBoundary}
\alias{pgGetBoundary}
\title{Retrieve bounding envelope of geometries or rasters.}
\usage{
pgGetBoundary(conn, name, geom = "geom")
}
\arguments{
\item{conn}{A connection object to a PostgreSQL database}

\item{name}{A character string specifying a PostgreSQL schema (if
necessary), and table or view name for the table holding the
geometries/raster(s) (e.g., name = c("schema","table"))}

\item{geom}{character, Name of the column in 'name' holding the
geometry or raster object (Default = 'geom')}
}
\value{
SpatialPolygon
}
\description{
Retrieve bounding envelope (rectangle) of all geometries or
rasters in a Postgresql table.
}
\examples{
\dontrun{
pgGetBoundary(conn, c("schema", "polys"), geom = "polygon")
pgGetBoundary(conn, c("schema", "rasters"), geom = "rast")
}
}
\author{
David Bucklin \email{dbucklin@ufl.edu}
}

