% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitDatasets.R
\name{lapplyDatasets}
\alias{lapplyDatasets}
\title{Lapply for generated datasets}
\usage{
lapplyDatasets(datasets, FUN, ..., label, POST_FUN, datasetIndices = "all")
}
\arguments{
\item{datasets}{Datasets list to be used to generate datasets.}

\item{FUN}{the function to be applied to each generated dataset. The
function will be called like \code{FUN(data, ...)}.}

\item{...}{optional arguments to \code{FUN}.}

\item{label}{optional parameter, if present, each result is added an
attribute named \emph{label} with the value of \code{label}.}

\item{POST_FUN}{function to be applied to the result of \code{FUN}. While
one could just modify \code{FUN} instead, this additional argument makes
it a bit easier to combine different kinds of methods together.}

\item{datasetIndices}{optional vector of dataset indices to fit, useful to
try only a few datasets instead of all of them. Use \code{"all"} to
process all datasets (default).}
}
\value{
list of results. The items in the resulting list will have two
  additional attributes: \code{datasetIndex} and \code{proc.time}. If
  \code{FUN} failed for an item, then the item  will be the error as
  returned by try, i.e., it ill be of class \code{try-error}.
}
\description{
Apply function for all generated datasets.
}
\examples{
  oneWay <- generateAnovaDatasets(2, 1, 5, 4)
  lapplyDatasets(oneWay, function(data) sum(data$y))
  lapplyDatasets(oneWay, function(data) sum(data$y), POST_FUN = function(x) x^2)
}
\author{
Manuel Koller
}
