% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rlistings_methods.R
\name{listing_methods}
\alias{listing_methods}
\alias{print.listing_df}
\alias{toString,listing_df-method}
\alias{[,listing_df-method}
\alias{main_title,listing_df-method}
\alias{subtitles,listing_df-method}
\alias{main_footer,listing_df-method}
\alias{prov_footer,listing_df-method}
\alias{main_title<-,listing_df-method}
\alias{subtitles<-,listing_df-method}
\alias{main_footer<-,listing_df-method}
\alias{prov_footer<-,listing_df-method}
\alias{num_rep_cols,listing_df-method}
\title{Methods for \code{listing_df} objects}
\usage{
\method{print}{listing_df}(x, widths = NULL, tf_wrap = FALSE, max_width = NULL, ...)

\S4method{toString}{listing_df}(x, ...)

\S4method{[}{listing_df}(x, i, j, drop = FALSE)

\S4method{main_title}{listing_df}(obj)

\S4method{subtitles}{listing_df}(obj)

\S4method{main_footer}{listing_df}(obj)

\S4method{prov_footer}{listing_df}(obj)

\S4method{main_title}{listing_df}(obj) <- value

\S4method{subtitles}{listing_df}(obj) <- value

\S4method{main_footer}{listing_df}(obj) <- value

\S4method{prov_footer}{listing_df}(obj) <- value

\S4method{num_rep_cols}{listing_df}(obj)
}
\arguments{
\item{x}{listing_df. The listing.}

\item{widths}{numeric (or  NULL). (proposed) widths for the columns
of \code{x}. The expected length  of this numeric vector can be
retrieved with  \code{ncol() + 1}  as the  column of row  names must
also be considered.}

\item{tf_wrap}{logical(1). Should  the texts for  title, subtitle,
and footnotes be wrapped?}

\item{max_width}{integer(1), character(1) or NULL. Width that title
and   footer   (including   footnotes)  materials   should   be
word-wrapped to. If NULL, it is  set to the current print width
of the  session (\code{getOption("width")}). If set to \code{"auto"},
the width of the table (plus any table inset) is used. Ignored
completely if \code{tf_wrap} is \code{FALSE}.}

\item{...}{dots. See \code{toString} method in \code{formatters} for all parameters.}

\item{i}{ANY. Passed to base \code{[} methods.}

\item{j}{ANY. Passed to base \code{[} methods.}

\item{drop}{For matrices and arrays.  If \code{TRUE} the result is
    coerced to the lowest possible dimension (see the examples).  This
    only works for extracting elements, not for the replacement.  See
    \code{\link[base]{drop}} for further details.
  }

\item{obj}{The object.}

\item{value}{typically an array-like \R object of a similar class as
    \code{x}.}
}
\value{
for getter methods, the value of the aspect of
\code{obj}; for setter methods, \code{obj} with
the relevant element of the listing updated.
}
\description{
See core documentation in \code{formatters} for descriptions
of these functions.
}
\examples{

lsting <- as_listing(mtcars)
main_title(lsting) <- "Hi there"

main_title(lsting)
}
\keyword{internal}
