% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-fascicles.R
\name{read_fascicles}
\alias{read_fascicles}
\title{Import fascicles into R}
\usage{
read_fascicles(file)
}
\arguments{
\item{file}{Path to the file containing the tractography data. Currently
supported files are \code{.vtk}, \code{.vtp}, \href{https://med.inria.fr}{medInria}
\code{.fds}, \code{.tck/.tsf}
\href{https://mrtrix.readthedocs.io/en/latest/getting_started/image_data.html}{MRtrix},
\code{.trk} \href{http://trackvis.org/docs/?subsect=fileformat}{TrackVis} file
formats.}
}
\value{
A \code{\link[tibble]{tibble}} storing the set of fascicles.
}
\description{
Import fascicles into R
}
\examples{
uf_left_vtk <- read_fascicles(system.file("extdata", "UF_left.vtk",  package = "riot"))
}
