% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-misc.R
\name{min_or_na}
\alias{min_or_na}
\alias{max_or_na}
\alias{is_val}
\alias{not_val}
\alias{is_true}
\alias{is_false}
\alias{last_elem}
\alias{first_elem}
\alias{replace_na}
\title{Utility functions}
\usage{
min_or_na(x)

max_or_na(x)

is_val(x, val)

not_val(x, val)

is_true(x)

is_false(x)

last_elem(x)

first_elem(x)

replace_na(x, val, ...)
}
\arguments{
\item{x}{Object to use}

\item{val}{Value to compare against}

\item{...}{Forwarded to other methods}
}
\value{
\itemize{
\item \code{min_or_na()}/\code{max_or_na()}: scalar-valued extrema of a vector
\item \code{is_val()}/\code{not_val()}/\code{is_true()}/\code{is_false()}: Logical vector of the
same length as the object passed as \code{x}
\item \code{first_elem()}/\code{last_elem()}: single element of the object passed as \code{x}
\item \code{replace_na()}: modified version of the object passed as \code{x}
}
}
\description{
Several utility functions exported for convenience.
}
\details{
The two functions \code{min_or_na()} and \code{max_or_na()} overcome a design choice
of \code{\link[base:Extremes]{base::min()}} (or \code{\link[base:Extremes]{base::max()}}\verb{) that can yield undesirable results. If called on a vector of all missing values with }na.rm = TRUE\verb{, }Inf\verb{(and}-Inf\verb{respectively) are returned. This is changed to returning a missing value of the same type as}x`.

The functions \code{is_val()} and \code{not_val()} (as well as analogously
\code{is_true()} and \code{is_false()}) return logical vectors of the same length as
the value passed as \code{x}, with non-base R semanticists of comparing against
\code{NA}: instead of returning \code{c(NA, TRUE)} for \code{c(NA, 5) == 5}, \code{is_val()}
will return \verb{c(FALSE TRUE)}. Passing \code{NA} as \code{val} might lead to unintended
results but no warning is thrown.

Finally, \code{first_elem()} and \code{last_elem()} has the same semantics as
\code{\link[utils:head]{utils::head()}} and \code{\link[utils:head]{utils::tail()}} with \code{n = 1L} and \code{replace_na()} will
replace all occurrences of \code{NA} in \code{x} with \code{val} and can be called on both
objects inheriting from \code{data.table} in which case internally
\code{\link[data.table:nafill]{data.table::setnafill()}} is called or other objects.
}
\examples{
some_na <- c(NA, sample(1:10, 5), NA)
identical(min(some_na, na.rm = TRUE), min_or_na(some_na))

all_na <- rep(NA, 5)
min(all_na, na.rm = TRUE)
min_or_na(all_na)

is_val(some_na, 5)
some_na == 5

is_val(some_na, NA)

identical(first_elem(letters), head(letters, n = 1L))
identical(last_elem(letters), tail(letters, n = 1L))

replace_na(some_na, 11)
replace_na(all_na, 11)
replace_na(1:5, 11)

tbl <- ts_tbl(a = 1:10, b = hours(1:10), c = c(NA, 1:5, NA, 8:9, NA))
res <- replace_na(tbl, 0)
identical(tbl, res)

}
