% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complex-cubical.R
\name{PeriodicCubicalComplex}
\alias{PeriodicCubicalComplex}
\title{R6 Class for Periodic Cubical Complex}
\description{
The \code{PeriodicCubicalComplex} class is an example of a structured
complex useful in computational mathematics (specially rigorous numerics)
and image analysis.
}
\examples{
\dontshow{if (reticulate::py_module_available("gudhi")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
n <- 10
X <- cbind(seq(0, 1, len = n), seq(0, 1, len = n))
pcc <- PeriodicCubicalComplex$new(
  top_dimensional_cells = X,
  periodic_dimensions = c(TRUE, FALSE)
)
pcc
\dontshow{\}) # examplesIf}
}
\seealso{
Other data structures for cell complexes: 
\code{\link{CubicalComplex}},
\code{\link{SimplexTree}}
}
\author{
Pawel Dlotko
}
\concept{data structures for cell complexes}
\section{Super classes}{
\code{rgudhi::PythonClass} -> \code{\link[rgudhi:CubicalComplex]{rgudhi::CubicalComplex}} -> \code{PeriodicCubicalComplex}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PeriodicCubicalComplex-new}{\code{PeriodicCubicalComplex$new()}}
\item \href{#method-PeriodicCubicalComplex-clone}{\code{PeriodicCubicalComplex$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgudhi::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgudhi::PythonClass$set_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="CubicalComplex" data-id="betti_numbers"><a href='../../rgudhi/html/CubicalComplex.html#method-CubicalComplex-betti_numbers'><code>rgudhi::CubicalComplex$betti_numbers()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="CubicalComplex" data-id="cofaces_of_persistence_pairs"><a href='../../rgudhi/html/CubicalComplex.html#method-CubicalComplex-cofaces_of_persistence_pairs'><code>rgudhi::CubicalComplex$cofaces_of_persistence_pairs()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="CubicalComplex" data-id="compute_persistence"><a href='../../rgudhi/html/CubicalComplex.html#method-CubicalComplex-compute_persistence'><code>rgudhi::CubicalComplex$compute_persistence()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="CubicalComplex" data-id="dimension"><a href='../../rgudhi/html/CubicalComplex.html#method-CubicalComplex-dimension'><code>rgudhi::CubicalComplex$dimension()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="CubicalComplex" data-id="num_simplices"><a href='../../rgudhi/html/CubicalComplex.html#method-CubicalComplex-num_simplices'><code>rgudhi::CubicalComplex$num_simplices()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="CubicalComplex" data-id="persistence"><a href='../../rgudhi/html/CubicalComplex.html#method-CubicalComplex-persistence'><code>rgudhi::CubicalComplex$persistence()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="CubicalComplex" data-id="persistence_intervals_in_dimension"><a href='../../rgudhi/html/CubicalComplex.html#method-CubicalComplex-persistence_intervals_in_dimension'><code>rgudhi::CubicalComplex$persistence_intervals_in_dimension()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="CubicalComplex" data-id="persistent_betti_numbers"><a href='../../rgudhi/html/CubicalComplex.html#method-CubicalComplex-persistent_betti_numbers'><code>rgudhi::CubicalComplex$persistent_betti_numbers()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PeriodicCubicalComplex-new"></a>}}
\if{latex}{\out{\hypertarget{method-PeriodicCubicalComplex-new}{}}}
\subsection{Method \code{new()}}{
Constructor from either \code{top_dimensional_cells} (and
possibly \code{dimensions}) or from a Perseus-style file name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PeriodicCubicalComplex$new(
  perseus_file,
  top_dimensional_cells,
  periodic_dimensions,
  dimensions = NULL,
  py_class = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{perseus_file}}{A character string specifying the path to a
Perseus-style file name.}

\item{\code{top_dimensional_cells}}{Either a numeric vector (in which case,
\code{dimensions} should be provided as well) or a multidimensional array
specifying cell filtration values.}

\item{\code{periodic_dimensions}}{A logical vector specifying the periodicity
value of the top dimensional cells.}

\item{\code{dimensions}}{An integer vector specifying the number of top
dimensional cells. Defaults to \code{NULL}.}

\item{\code{py_class}}{An existing \code{PeriodicCubicalComplex} Python class.
Defaults to \code{NULL} which uses the Python class constructor instead.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A new \code{\link{PeriodicCubicalComplex}} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PeriodicCubicalComplex-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PeriodicCubicalComplex-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PeriodicCubicalComplex$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
