% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/representation-metrics.R
\name{PersistenceFisherDistance}
\alias{PersistenceFisherDistance}
\title{Metrics: Persistence Fisher Distance}
\description{
Computes the persistence Fisher distance matrix from a list of
persistence diagrams. The persistence Fisher distance is obtained by
computing the original Fisher distance between the probability
distributions associated to the persistence diagrams given by convolving
them with a Gaussian kernel. See
http://papers.nips.cc/paper/8205-persistence-fisher-kernel-a-riemannian-manifold-kernel-for-persistence-diagrams
for more details.
}
\examples{
\dontshow{if (reticulate::py_module_available("gudhi")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
X <- seq_circle(10)
ac <- AlphaComplex$new(points = X)
st <- ac$create_simplex_tree()
dgm <- st$compute_persistence()$persistence_intervals_in_dimension(0)
ds <- DiagramSelector$new(use = TRUE)
dgm <- ds$apply(dgm)
dis <- PersistenceFisherDistance$new()
dis$apply(dgm, dgm)
dis$fit_transform(list(dgm))
\dontshow{\}) # examplesIf}
}
\author{
Mathieu Carrière
}
\section{Super classes}{
\code{rgudhi::PythonClass} -> \code{rgudhi::SKLearnClass} -> \code{\link[rgudhi:MetricStep]{rgudhi::MetricStep}} -> \code{PersistenceFisherDistance}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-PersistenceFisherDistance-new}{\code{PersistenceFisherDistance$new()}}
\item \href{#method-PersistenceFisherDistance-clone}{\code{PersistenceFisherDistance$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="get_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-get_python_class'><code>rgudhi::PythonClass$get_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="PythonClass" data-id="set_python_class"><a href='../../rgudhi/html/PythonClass.html#method-PythonClass-set_python_class'><code>rgudhi::PythonClass$set_python_class()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="get_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-get_params'><code>rgudhi::SKLearnClass$get_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="SKLearnClass" data-id="set_params"><a href='../../rgudhi/html/SKLearnClass.html#method-SKLearnClass-set_params'><code>rgudhi::SKLearnClass$set_params()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="MetricStep" data-id="apply"><a href='../../rgudhi/html/MetricStep.html#method-MetricStep-apply'><code>rgudhi::MetricStep$apply()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="MetricStep" data-id="fit"><a href='../../rgudhi/html/MetricStep.html#method-MetricStep-fit'><code>rgudhi::MetricStep$fit()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="MetricStep" data-id="fit_transform"><a href='../../rgudhi/html/MetricStep.html#method-MetricStep-fit_transform'><code>rgudhi::MetricStep$fit_transform()</code></a></span></li>
<li><span class="pkg-link" data-pkg="rgudhi" data-topic="MetricStep" data-id="transform"><a href='../../rgudhi/html/MetricStep.html#method-MetricStep-transform'><code>rgudhi::MetricStep$transform()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PersistenceFisherDistance-new"></a>}}
\if{latex}{\out{\hypertarget{method-PersistenceFisherDistance-new}{}}}
\subsection{Method \code{new()}}{
The \code{\link{PersistenceFisherDistance}} constructor.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PersistenceFisherDistance$new(bandwidth = 1, kernel_approx = NULL, n_jobs = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{bandwidth}}{A numeric value specifying the bandwidth of the Gaussian
kernel applied to the persistence Fisher distance. Defaults to \code{1.0}.}

\item{\code{kernel_approx}}{A Python class specifying the kernel approximation
class used to speed up computation. Defaults to \code{NULL}. Common kernel
approximations classes can be found in the \strong{scikit-learn} library
(such as \code{RBFSampler} for instance).}

\item{\code{n_jobs}}{An integer value specifying the number of jobs to use for
the computation. Defaults to \code{1L}.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
An object of class \code{\link{PersistenceFisherDistance}}.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-PersistenceFisherDistance-clone"></a>}}
\if{latex}{\out{\hypertarget{method-PersistenceFisherDistance-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PersistenceFisherDistance$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
