% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/occ_get.r
\name{occ_get}
\alias{occ_get}
\title{Get data for specific GBIF occurrences.}
\usage{
occ_get(
  key = NULL,
  return = "all",
  verbatim = FALSE,
  fields = "minimal",
  curlopts = list()
)
}
\arguments{
\item{key}{Occurrence key}

\item{return}{One of data, hier, meta, or all. If "data", a data.frame
with the data. "hier" returns the classifications in a list for each record.
meta returns the metadata for the entire call. 'all' gives all data back
in a list. Ignored if \code{verbatim=TRUE}.}

\item{verbatim}{Return verbatim object (TRUE) or cleaned up object (FALSE,
default).}

\item{fields}{(character) Default ("minimal") will return just taxon name,
key, latitude, and longitute. 'all' returns all fields. Or specify each
field you want returned by name, e.g. fields = c('name',
'decimalLatitude','altitude').}

\item{curlopts}{list of named curl options passed on to
\code{\link[crul]{HttpClient}}. see \code{\link[curl]{curl_options}}
for curl options}
}
\value{
A data.frame or list of data.frame's.
}
\description{
Get data for specific GBIF occurrences.
}
\examples{
\dontrun{
occ_get(key=855998194, return="data")
occ_get(key=855998194, "hier")
occ_get(key=855998194, 'all')

# many occurrences
occ_get(key=c(101010, 240713150, 855998194), return="data")

# Verbatim data
occ_get(key=855998194, verbatim=TRUE)
occ_get(key=855998194, fields='all', verbatim=TRUE)
occ_get(key=855998194, fields=c('scientificName', 'lastCrawled', 'county'),
  verbatim=TRUE)
occ_get(key=c(855998194, 620594291), verbatim=TRUE)
occ_get(key=c(855998194, 620594291), fields='all', verbatim=TRUE)
occ_get(key=c(855998194, 620594291),
   fields=c('scientificName', 'decimalLatitude', 'basisOfRecord'),
   verbatim=TRUE)

# Pass in curl options
occ_get(key=855998194, curlopts = list(verbose=TRUE))
}
}
\references{
\url{https://www.gbif.org/developer/occurrence#occurrence}
}
