% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find-location.R
\name{find_location}
\alias{find_location}
\title{Get location ID depending on a query term.}
\usage{
find_location(term, location_types = NA, locale = "en-US")
}
\arguments{
\item{term}{searched term (for suggestions). This parameter expects a full
IATA code. If IATA code is not given, the search will go through other
available fields: ‘name’ or ‘code’ of the location. It also depends on the
‘location_types’ specified eg. airport, city, country. The search that is
used behind the scenes is elasticsearch. It returns data based on relevancy
and many other factors.}

\item{location_types}{list of desired location output, accepted values:
station, airport, bus_station, city, autonomous_territory, subdivision,
country, region, continent.}

\item{locale}{desired locale output - this is the language of the results.
Should any other locale be used other than the specified locales.}
}
\description{
Get location ID depending on a query term using the
[Kiwi API](https://docs.kiwi.com/).
}
\examples{
\donttest{
cba_locs <- find_location("Cordoba", location_types = c("city", "airport"))
# show some info of the found locations
lapply(cba_locs, function(act_loc) {
  c(act_loc$name, act_loc$country$name)
})
}

}
