% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wcc_rhelp.r
\name{rhelp}
\alias{rhelp}
\alias{rhelp}
\alias{help}
\alias{?}
\title{rhelp}
\usage{
rhelp(topic, package = NULL, lib.loc = NULL,
  verbose = getOption("verbose"),
  try.all.packages = getOption("help.try.all.packages"))

help(topic, package = NULL, lib.loc = NULL,
  verbose = getOption("verbose"),
  try.all.packages = getOption("help.try.all.packages"))

"?"(e1, e2)
}
\arguments{
\item{topic, e1, e2}{A topic as in \code{utils::help()}}

\item{package}{A package as in \code{utils::help()}}

\item{lib.loc}{A lib location as in \code{utils::help()}}

\item{verbose}{if verbose on/off as in \code{utils::help()}}

\item{try.all.packages}{if try all packages as in \code{utils::help()}}
}
\description{
Provide the primary interface to the help systems as \code{utils::help()}
}
\details{
Remote R Help System
}
\examples{
\dontrun{
### Prompts are listed to clarify when something is eval'd locally vs
### remotely
> # suppressMessages(library(remoter, quietly = TRUE))
> # client()
> remoter::client("192.168.56.101")

remoter> rhelp("plot")
remoter> rhelp(package = "remoter")
remoter> rhelp("plot", package = "remoter")

remoter> rhelp("dev.off")
remoter> rhelp("dev.off", package = "remoter")
remoter> rhelp("dev.off", package = "grDevices")

remoter> help("par")

remoter> ?`+`
remoter> ?`?`
remoter> ?"??"
remoter> package?base
remoter> `?`(package, remoter)


remoter> q()
>
}

}
