% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_select_threshold.R,
%   R/select_threshold.R
\name{select_threshold.cluster_pairs}
\alias{select_threshold.cluster_pairs}
\alias{select_threshold}
\alias{select_threshold.pairs}
\title{Select matching pairs with a score above or equal to a threshold}
\usage{
\method{select_threshold}{cluster_pairs}(pairs, variable, score, threshold, new_name = NULL, ...)

select_threshold(pairs, variable, score, threshold, ...)

\method{select_threshold}{pairs}(pairs, variable, score, threshold, inplace = FALSE, ...)
}
\arguments{
\item{pairs}{a \code{pairs} object, such as generated by 
\code{\link{pair_blocking}}}

\item{variable}{the name of the new variable to create in pairs. This will be a
logical variable with a value of \code{TRUE} for the selected pairs.}

\item{score}{name of the score/weight variable of the pairs. When not given
and \code{attr(pairs, "score")} is defined, that is used.}

\item{threshold}{the threshold to apply. Pairs with a score above or equal to the 
threshold are selected.}

\item{new_name}{name of new object to assign the pairs to on the cluster
nodes.}

\item{...}{ignored}

\item{inplace}{logical indicating whether \code{pairs} should be modified in place. When
pairs is large this can be more efficient.}
}
\value{
Returns the \code{pairs} with the variable given by \code{variable} added. This
is a logical variable indicating which pairs are selected a matches.
}
\description{
Select matching pairs with a score above or equal to a threshold
}
\examples{
data("linkexample1", "linkexample2")
pairs <- pair_blocking(linkexample1, linkexample2, "postcode")
pairs <- compare_pairs(pairs, c("lastname", "firstname", "address", "sex"))
model <- problink_em(~ lastname + firstname + address + sex, data = pairs)
pairs <- predict(model, pairs, type = "mpost", add = TRUE, binary = TRUE)
# Select pairs with a mpost > 0.5
select_threshold(pairs, "selected", "mpost", 0.5, inplace = TRUE)

# Example using cluster;
# In general the syntax is exactly the same except for the first call to 
# to cluster_pair. Note the in general `inplace = TRUE` is implied when
# working with a cluster; therefore the assignment back to pairs can be 
# omitted (also not a problem if it is not).
library(parallel)
data("linkexample1", "linkexample2")
cl <- makeCluster(2)
\dontshow{clusterEvalQ(cl, data.table::setDTthreads(1))}
pairs <- cluster_pair(cl, linkexample1, linkexample2)
compare_pairs(pairs, c("lastname", "firstname", "address", "sex"))
model <- problink_em(~ lastname + firstname + address + sex, data = pairs)
predict(model, pairs, type = "mpost", add = TRUE, binary = TRUE)
# Select pairs with a mpost > 0.5
# Unlike the regular pairs: inplace = TRUE is implied here
select_threshold(pairs, "selected", "mpost", 0.5)
stopCluster(cl)

}
