% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/discretize.R
\name{step_discretize}
\alias{step_discretize}
\alias{tidy.step_discretize}
\title{Discretize Numeric Variables}
\usage{
step_discretize(
  recipe,
  ...,
  role = NA,
  trained = FALSE,
  num_breaks = 4,
  min_unique = 10,
  objects = NULL,
  options = list(),
  skip = FALSE,
  id = rand_id("discretize")
)

\method{tidy}{step_discretize}(x, ...)
}
\arguments{
\item{recipe}{A recipe object. The step will be added to the
sequence of operations for this recipe.}

\item{...}{For \code{step_discretize}, the dots specify
one or more selector functions to choose which variables are
affected by the step. See \code{\link[=selections]{selections()}} for more
details. For the \code{tidy} method, these are not currently
used.}

\item{role}{Not used by this step since no new variables are
created.}

\item{trained}{A logical to indicate if the quantities for
preprocessing have been estimated.}

\item{num_breaks}{An integer defining how many cuts to make of the
data.}

\item{min_unique}{An integer defining a sample size line of
dignity for the binning. If (the number of unique
values)\verb{/(cuts+1)} is less than \code{min_unique}, no
discretization takes place.}

\item{objects}{The \code{\link[=discretize]{discretize()}} objects are stored
here once the recipe has be trained by
\code{\link[=prep.recipe]{prep.recipe()}}.}

\item{options}{A list of options to \code{\link[=discretize]{discretize()}}. A
default is set for the argument \code{x}. Note that using
the options \code{prefix} and \code{labels} when more than one
variable is being transformed might be problematic as all
variables inherit those values.}

\item{skip}{A logical. Should the step be skipped when the
recipe is baked by \code{\link[=bake.recipe]{bake.recipe()}}? While all operations are baked
when \code{\link[=prep.recipe]{prep.recipe()}} is run, some operations may not be able to be
conducted on new data (e.g. processing the outcome variable(s)).
Care should be taken when using \code{skip = TRUE} as it may affect
the computations for subsequent operations}

\item{id}{A character string that is unique to this step to identify it.}

\item{x}{A \code{step_discretize} object}
}
\value{
\code{step_discretize} returns an updated version of
\code{recipe} with the new step added to the sequence of
existing steps (if any). For the \code{tidy} method, a tibble
with columns \code{terms} (the selectors or variables selected)
and \code{value} (the breaks).
}
\description{
\code{step_discretize} creates a \emph{specification} of a recipe
step that will convert numeric data into a factor with
bins having approximately the same number of data points (based
on a training set).
}
