% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/consistency.R
\name{strattest}
\alias{strattest}
\title{Consistency Tests for the Abundance Estimator, Complete Stratification}
\usage{
strattest(n1, n2, m2, ...)
}
\arguments{
\item{n1}{Vector of n1 counts (sample size in the first event), each element
corresponding to one stratum.}

\item{n2}{Vector of n2 counts (sample size in the second event), each element
corresponding to one stratum.}

\item{m2}{Vector of m2 counts (number of recaptures in the second event),
each element corresponding to one stratum.}

\item{...}{Additional arguments for \link[stats]{chisq.test}}
}
\value{
A list of class \code{"recapr_strattest"} with the following
  components: \itemize{ \item{\code{event1_table}} {The contingency table
  used for the first test} \item{\code{event1_Xsqd}} {The chi-squared test
  statistic in the first test} \item{\code{event1_df}} {The associated
  degrees of freedom in the first test} \item{\code{event1_pval}} {The
  p-value returned from the first test} \item{\code{event2_table}} {The
  contingency table used for the second test} \item{\code{event2_Xsqd}} {The
  chi-squared test statistic in the second test} \item{\code{event2_df}} {The
  associated degrees of freedom in the second test} \item{\code{event2_pval}}
  {The p-value returned from the second test} \item{\code{event1v2_table}}
  {The contingency table used for the third test} \item{\code{event1v2_Xsqd}}
  {The chi-squared test statistic in the third test}
  \item{\code{event1v2_df}} {The associated degrees of freedom in the third
  test} \item{\code{event1v2_pval}} {The p-value returned from the second
  third} }
}
\description{
Conducts two chi-squared tests for the consistency of the
  Petersen-type abundance estimator.  These tests provide explore evidence
  against equal capture probabilities in either the first or second sampling
  event.  Also conducts a third chi-squared test of unequal capture
  probabilities between sampling events for each stratum, in the case of
  small sample sizes (fewer than 100 in either sampling event and fewer than
  30 recaptures), which may be used to suggest unequal capture probabilities
  in either the first or second event.

  Typically, if either of the first two test p-values is greater than the
  significance level, use of a Petersen-type estimator is considered
  justified.

  If tests give evidence of unequal capture probabilities between strata, a
  stratified estimator should be used, such as \link{Nstrat}.

  This function assumes stratification in both sampling events, such that
  individuals cannot move from one strata to another (such as by size or
  gender).  If movement between strata may occur (such as in the case of
  stratification by time or area), use of \link{consistencytest} is
  recommended.
}
\note{
Any Petersen-type estimator (such as this) depends on a set of
  assumptions: \itemize{ \item  The population is closed; that is, that there
  are no births, deaths, immigration, or emigration between sampling events
  \item All individuals have the same probability of capture in one of the
  two events, or complete mixing occurs between events \item Marking in the
  first event does not affect probability of recapture in the second event
  \item Individuals do not lose marks between events \item All marks will be
  reported in the second event }
}
\examples{
strattest(n1=c(100,100), n2=c(50,200), m2=c(20,15))
}
\seealso{
\link{powstrattest}, \link{Nstrat}, \link{consistencytest}
}
\author{
Matt Tyers
}
