% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tensor.R
\name{Tensor}
\alias{Tensor}
\title{R6 Class for large Tensor (Array) in Hybrid Mode}
\description{
can store on hard drive, and read slices of GB-level
data in seconds
}
\examples{

if(interactive()){  # Avoid checkings from CRAN

# Create a tensor
ts <- Tensor$new(
  data = 1:18000000, c(3000,300,20),
  dimnames = list(A = 1:3000, B = 1:300, C = 1:20),
  varnames = c('A', 'B', 'C'))

# Size of tensor when in memory is usually large
# `lobstr::obj_size(ts)` -> 8.02 MB

# Enable hybrid mode
ts$to_swap_now()

# Hybrid mode, usually less than 1 MB
# `lobstr::obj_size(ts)` -> 814 kB

# Subset data
start1 <- Sys.time()
subset(ts, C ~ C < 10 & C > 5, A ~ A < 10)
#> Dimension:  9 x 300 x 4
#> - A: 1, 2, 3, 4, 5, 6,...
#> - B: 1, 2, 3, 4, 5, 6,...
#> - C: 6, 7, 8, 9
end1 <- Sys.time(); end1 - start1
#> Time difference of 0.188035 secs

# Join tensors
ts <- lapply(1:20, function(ii){
  Tensor$new(
    data = 1:9000, c(30,300,1),
    dimnames = list(A = 1:30, B = 1:300, C = ii),
    varnames = c('A', 'B', 'C'), use_index = 2)
})
ts <- join_tensors(ts, temporary = TRUE)

}

}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{dim}}{dimension of the array}

\item{\code{dimnames}}{dimension names of the array}

\item{\code{use_index}}{whether to use one dimension as index when storing data
as multiple files}

\item{\code{hybrid}}{whether to allow data to be written to disk}

\item{\code{last_used}}{timestamp of the object was read}

\item{\code{temporary}}{whether to remove the files once garbage collected}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{varnames}}{dimension names (read-only)}

\item{\code{read_only}}{whether to protect the swap files from being changed}

\item{\code{swap_file}}{file or files to save data to}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Tensor-finalize}{\code{Tensor$finalize()}}
\item \href{#method-Tensor-print}{\code{Tensor$print()}}
\item \href{#method-Tensor-.use_multi_files}{\code{Tensor$.use_multi_files()}}
\item \href{#method-Tensor-new}{\code{Tensor$new()}}
\item \href{#method-Tensor-subset}{\code{Tensor$subset()}}
\item \href{#method-Tensor-flatten}{\code{Tensor$flatten()}}
\item \href{#method-Tensor-to_swap}{\code{Tensor$to_swap()}}
\item \href{#method-Tensor-to_swap_now}{\code{Tensor$to_swap_now()}}
\item \href{#method-Tensor-get_data}{\code{Tensor$get_data()}}
\item \href{#method-Tensor-set_data}{\code{Tensor$set_data()}}
\item \href{#method-Tensor-collapse}{\code{Tensor$collapse()}}
\item \href{#method-Tensor-operate}{\code{Tensor$operate()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Tensor-finalize"></a>}}
\if{latex}{\out{\hypertarget{method-Tensor-finalize}{}}}
\subsection{Method \code{finalize()}}{
release resource and remove files for temporary instances
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Tensor$finalize()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Tensor-print"></a>}}
\if{latex}{\out{\hypertarget{method-Tensor-print}{}}}
\subsection{Method \code{print()}}{
print out the data dimensions and snapshot
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Tensor$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{ignored}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
self
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Tensor-.use_multi_files"></a>}}
\if{latex}{\out{\hypertarget{method-Tensor-.use_multi_files}{}}}
\subsection{Method \code{.use_multi_files()}}{
Internally used, whether to use multiple files to cache
data instead of one
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Tensor$.use_multi_files(mult)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{mult}}{logical}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Tensor-new"></a>}}
\if{latex}{\out{\hypertarget{method-Tensor-new}{}}}
\subsection{Method \code{new()}}{
constructor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Tensor$new(
  data,
  dim,
  dimnames,
  varnames,
  hybrid = FALSE,
  use_index = FALSE,
  swap_file = temp_tensor_file(),
  temporary = TRUE,
  multi_files = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{numeric array}

\item{\code{dim}}{dimension of the array}

\item{\code{dimnames}}{dimension names of the array}

\item{\code{varnames}}{characters, names of \code{dimnames}}

\item{\code{hybrid}}{whether to enable hybrid mode}

\item{\code{use_index}}{whether to use the last dimension for indexing}

\item{\code{swap_file}}{where to store the data in hybrid mode
files to save data by index; default stores in
\code{raveio_getopt('tensor_temp_path')}}

\item{\code{temporary}}{whether to remove temporary files when existing}

\item{\code{multi_files}}{if \code{use_index} is true, whether to use multiple}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Tensor-subset"></a>}}
\if{latex}{\out{\hypertarget{method-Tensor-subset}{}}}
\subsection{Method \code{subset()}}{
subset tensor
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Tensor$subset(..., drop = FALSE, data_only = FALSE, .env = parent.frame())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{dimension slices}

\item{\code{drop}}{whether to apply \code{\link{drop}} on subset data}

\item{\code{data_only}}{whether just return the data value, or wrap them as a
\code{Tensor} instance}

\item{\code{.env}}{environment where \code{...} is evaluated}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the sliced data
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Tensor-flatten"></a>}}
\if{latex}{\out{\hypertarget{method-Tensor-flatten}{}}}
\subsection{Method \code{flatten()}}{
converts tensor (array) to a table (data frame)
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Tensor$flatten(include_index = FALSE, value_name = "value")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{include_index}}{logical, whether to include dimension names}

\item{\code{value_name}}{character, column name of the value}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a data frame with the dimension names as index columns and
\code{value_name} as value column
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Tensor-to_swap"></a>}}
\if{latex}{\out{\hypertarget{method-Tensor-to_swap}{}}}
\subsection{Method \code{to_swap()}}{
Serialize tensor to a file and store it via
\code{\link[fst]{write_fst}}
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Tensor$to_swap(use_index = FALSE, delay = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{use_index}}{whether to use one of the dimension as index for faster
loading}

\item{\code{delay}}{if greater than 0, then check when last used, if not long
ago, then do not swap to hard drive. If the difference of time is
greater than \code{delay} in seconds, then swap immediately.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Tensor-to_swap_now"></a>}}
\if{latex}{\out{\hypertarget{method-Tensor-to_swap_now}{}}}
\subsection{Method \code{to_swap_now()}}{
Serialize tensor to a file and store it via
\code{\link[fst]{write_fst}} immediately
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Tensor$to_swap_now(use_index = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{use_index}}{whether to use one of the dimension as index for faster
loading}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Tensor-get_data"></a>}}
\if{latex}{\out{\hypertarget{method-Tensor-get_data}{}}}
\subsection{Method \code{get_data()}}{
restore data from hard drive to memory
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Tensor$get_data(drop = FALSE, gc_delay = 3)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{drop}}{whether to apply \code{\link{drop}} to the data}

\item{\code{gc_delay}}{seconds to delay the garbage collection}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
original array
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Tensor-set_data"></a>}}
\if{latex}{\out{\hypertarget{method-Tensor-set_data}{}}}
\subsection{Method \code{set_data()}}{
set/replace data with given array
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Tensor$set_data(v)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{v}}{the value to replace the old one, must have the same dimension}

\item{\code{notice}}{the a tensor is an environment. If you change at one place,
the data from all other places will change. So use it carefully.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Tensor-collapse"></a>}}
\if{latex}{\out{\hypertarget{method-Tensor-collapse}{}}}
\subsection{Method \code{collapse()}}{
apply mean, sum, or median to collapse data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Tensor$collapse(keep, method = "mean")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{keep}}{which dimensions to keep}

\item{\code{method}}{\code{"mean"}, \code{"sum"}, or \code{"median"}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the collapsed data
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Tensor-operate"></a>}}
\if{latex}{\out{\hypertarget{method-Tensor-operate}{}}}
\subsection{Method \code{operate()}}{
apply the tensor by anything along given dimension
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Tensor$operate(
  by,
  fun = .Primitive("/"),
  match_dim,
  mem_optimize = FALSE,
  same_dimension = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{by}}{R object}

\item{\code{fun}}{function to apply}

\item{\code{match_dim}}{which dimensions to match with the data}

\item{\code{mem_optimize}}{optimize memory}

\item{\code{same_dimension}}{whether the return value has the same dimension as
the original instance}
}
\if{html}{\out{</div>}}
}
}
}
