% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rave-server.R
\name{rave-server}
\alias{rave-server}
\alias{rave_server_install}
\alias{rave_server_configure}
\title{Install and configure 'RAVE' server as background service using
shiny-server}
\usage{
rave_server_install(
  url = "https://github.com/rstudio/shiny-server/archive/refs/tags/v1.5.18.987.zip"
)

rave_server_configure(
  ports = 17283,
  user = Sys.info()[["user"]],
  rave_version = c("1", "2")
)
}
\arguments{
\item{url}{'URL' to shiny-server 'ZIP' file to download}

\item{ports}{integer vectors or character, indicating the port numbers to
host 'RAVE' instances a valid port must be within the range from 1024 to
65535.}

\item{user}{user to run the service as; default is the login user}

\item{rave_version}{internally used; might be deprecated in the future}
}
\value{
nothing
}
\description{
Works on 'Linux' and 'Mac' only.
}
\examples{
\dontrun{

# OS-specific. Please install R package `rpymat` first

# Install rave-server
rave_server_install()

# Let port 17283-17290 to host RAVE instance
rave_server_configure(ports = "17283-17290")

}
}
