% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/toMatrix.R
\name{toMatrix}
\alias{toMatrix}
\title{Matrix representation of the order generated by a set of intervals}
\usage{
toMatrix(intervals, strict = FALSE, binary = FALSE)
}
\arguments{
\item{intervals}{data frame (see \link{generateIntervals} for
the required format)}

\item{strict}{is this <= or <?}

\item{binary}{output is coded as 0/1 if TRUE and FALSE/TRUE otherwise}
}
\value{
A boolean matrix.  If strict is set to TRUE, the (i, j)th entry is
intervals[i, 'right'] < intervals[j, 'left'].  If strict is set to false, <=
is used in place of <.
}
\description{
Represent the order generated by a set of intervals as a boolean matrix.
This is a common input format for programs that operate on partial orders.
}
\examples{
intervals <- generateIntervals(10)
toMatrix(intervals)

}
