% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sampling.R
\name{sampling}
\alias{sampling}
\title{Simple random sampling}
\usage{
sampling(
  dataset,
  vars,
  sample_size,
  seed = 1234,
  data_filter = "",
  na.rm = FALSE,
  envir = parent.frame()
)
}
\arguments{
\item{dataset}{Dataset to sample from}

\item{vars}{The variables to sample}

\item{sample_size}{Number of units to select}

\item{seed}{Random seed to use as the starting point}

\item{data_filter}{Expression entered in, e.g., Data > View to filter the dataset in Radiant. The expression should be a string (e.g., "price > 10000")}

\item{na.rm}{Remove rows with missing values (FALSE or TRUE)}

\item{envir}{Environment to extract data from}
}
\value{
A list  of class 'sampling' with all variables defined in the sampling function
}
\description{
Simple random sampling
}
\details{
See \url{https://radiant-rstats.github.io/docs/design/sampling.html} for an example in Radiant
}
\examples{
sampling(rndnames, "Names", 10)

}
\seealso{
\code{\link{summary.sampling}} to summarize results
}
