% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_notes.R
\name{write_notes}
\alias{write_notes}
\title{Create a project README file}
\usage{
write_notes(path = here::here())
}
\arguments{
\item{path}{The destination directory for the progress notes file. Defaults to \code{
here::here()}.}
}
\value{
Creates a chronological project progress notes tracker
}
\description{
This function streamlines project documentation by creating and managing both README.md
and dated_progress_notes.md files. It provides interactive prompts for existing files
and maintains consistent project documentation structure.
}
\details{
The dated_progress_notes.md file is initialized with the current date and is designed
to help track project milestones chronologically. If the progress notes file already 
exists, the function will stop and warn the user.
}
\examples{
# Create new progress note file in temporary directory
tmp <- tempdir()
write_notes(path = tmp)
}
