% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kpi_groups.R
\name{kpi_grp_describe}
\alias{kpi_grp_describe}
\title{Describe the KPIs in a Kolada KPI Group metadata table}
\usage{
kpi_grp_describe(
  kpi_grp_df,
  max_n = 5,
  format = "inline",
  heading_level = 2,
  sub_heading_level = heading_level + 1
)
}
\arguments{
\item{kpi_grp_df}{A Kolada KPI Group metadata table, as created by e.g.
\code{get_kpi_groups}.}

\item{max_n}{The maximum number of KPI groups to describe.}

\item{format}{Output format. Can be one of "inline" or "md" (markdown).}

\item{heading_level}{The top heading level output format is "md".}

\item{sub_heading_level}{The sub heading level output format is "md".}
}
\value{
Returns the object passed to the function, invisibly, to be re-used
in a pipe.
}
\description{
Print a human-readable description of each row of a KPI Group metadata table,
including member KPIs (up to a maximum number of rows). Can be printed either
directly to the R console or used to populate a R markdown document, which
can be useful for documentation purposes.
}
