# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title FTRL-Proximal Linear Model Predicting Function
#'
#' @description
#' FTRLProx_predict_spMatrix predicts values based on linear model weights.
#' This function is an C++ implementation.
#' This function is used internally and is not intended for end-user direct usage.
#'
#' @param x a transposed \code{dgCMatrix} object.
#' @param w an vector of linear model weights.
#' @param family link function to be used in the model. "gaussian", "binomial" and "poisson" are avaliable.
#' @return an vector of linear model predicted values
#' @export
FTRLProx_predict_spMatrix <- function(x, w, family) {
    .Call('rFTRLProximal_FTRLProx_predict_spMatrix', PACKAGE = 'rFTRLProximal', x, w, family)
}

#' @title FTRL-Proximal Linear Model Fitting Function
#'
#' @description
#' FTRLProx_train_spMatrix estimates the weights of linear model using FTRL-Proximal Algorithm.
#' This function is an C++ implementation.
#' This function is used internally and is not intended for end-user direct usage.
#'
#' @param x a transposed \code{dgCMatrix}.
#' @param y a vector containing labels.
#' @param family link function to be used in the model. "gaussian", "binomial" and "poisson" are avaliable.
#' @param params a list of parameters of FTRL-Proximal Algorithm.
#' \itemize{
#'   \item \code{alpha} alpha in the per-coordinate learning rate
#'   \item \code{beta} beta in the per-coordinate learning rate
#'   \item \code{l1} L1 regularization parameter
#'   \item \code{l2} L2 regularization parameter
#' }
#' @param epoch The number of iterations over training data to train the model.
#' @param verbose logical value. Indicating if the progress bar is displayed or not.
#' @return an vector of linear model weights
#' @export
FTRLProx_train_spMatrix <- function(x, y, family, params, epoch, verbose) {
    .Call('rFTRLProximal_FTRLProx_train_spMatrix', PACKAGE = 'rFTRLProximal', x, y, family, params, epoch, verbose)
}

#' @title FTRL-Proximal Linear Model Validation Function
#'
#' @description
#' FTRLProx_validate_spMatrix validates the performance of FTRL-Proximal online learning model.
#' This function is an C++ implementation.
#' This function is used internally and is not intended for end-user direct usage.
#'
#' @param x a transposed \code{dgCMatrix}.
#' @param y a vector containing labels.
#' @param family link function to be used in the model. "gaussian", "binomial" and "poisson" are avaliable.
#' @param params a list of parameters of FTRL-Proximal Algorithm.
#' \itemize{
#'   \item \code{alpha} alpha in the per-coordinate learning rate
#'   \item \code{beta} beta in the per-coordinate learning rate
#'   \item \code{l1} L1 regularization parameter
#'   \item \code{l2} L2 regularization parameter
#' }
#' @param epoch The number of iterations over training data to train the model.
#' @param val_x a transposed \code{dgCMatrix} for validation.
#' @param val_y a vector containing labels for validation.
#' @param eval a evaluation metrics computing function, the first argument shoule be prediction, the second argument shoule be label.
#' @param verbose logical value. Indicating if the validation result for each epoch is displayed or not.
#' @return a FTRL-Proximal linear model object
#' @export
FTRLProx_validate_spMatrix <- function(x, y, family, params, epoch, val_x, val_y, eval, verbose) {
    .Call('rFTRLProximal_FTRLProx_validate_spMatrix', PACKAGE = 'rFTRLProximal', x, y, family, params, epoch, val_x, val_y, eval, verbose)
}

