% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_TrendLine.R, R/class_TrendLine_setters.R
\docType{methods}
\name{initialize,TrendLine-method}
\alias{initialize,TrendLine-method}
\alias{trendLine}
\alias{setInitialValue}
\alias{setInitialValue,TrendLine,numeric-method}
\alias{setInitialXValue}
\alias{setInitialXValue,TrendLine,numeric-method}
\alias{setFinalValue}
\alias{setFinalValue,TrendLine,numeric-method}
\alias{setFinalXValue}
\alias{setFinalXValue,TrendLine,numeric-method}
\alias{setValueAxis,TrendLine,ValueAxisOrCharacterOrMissing-method}
\alias{setValueAxisX}
\alias{setValueAxisX,TrendLine,ValueAxisOrCharacterOrMissing-method}
\title{Initializes a TrendLine}
\usage{
\S4method{initialize}{TrendLine}(.Object, initialValue, initialXValue,
  finalValue, finalXValue, valueAxis, valueAxisX, ...)

trendLine(.Object, initialValue, initialXValue, finalValue, finalXValue,
  valueAxis, valueAxisX, ...)

setInitialValue(.Object, initialValue)

\S4method{setInitialValue}{TrendLine,numeric}(.Object, initialValue)

setInitialXValue(.Object, initialXValue)

\S4method{setInitialXValue}{TrendLine,numeric}(.Object, initialXValue)

setFinalValue(.Object, finalValue)

\S4method{setFinalValue}{TrendLine,numeric}(.Object, finalValue)

setFinalXValue(.Object, finalXValue)

\S4method{setFinalXValue}{TrendLine,numeric}(.Object, finalXValue)

\S4method{setValueAxis}{TrendLine,ValueAxisOrCharacterOrMissing}(.Object,
  valueAxis = NULL, ...)

setValueAxisX(.Object, valueAxisX = NULL, ...)

\S4method{setValueAxisX}{TrendLine,ValueAxisOrCharacterOrMissing}(.Object,
  valueAxisX = NULL, ...)
}
\arguments{
\item{.Object}{\linkS4class{TrendLine}.}

\item{initialValue}{\code{numeric}, value from which trend line should start.}

\item{initialXValue}{\code{numeric}, used by XY chart only. X value from which trend line should start.}

\item{finalValue}{\code{numeric}, value at which trend line should end.}

\item{finalXValue}{\code{numeric}, used by XY chart only. X value at which trend line should end.}

\item{valueAxis}{\linkS4class{ValueAxis}.
Value axis of the trend line. Will use first value axis of the chart if not set any.
You can use a reference to the value axis object or id of value axis.}

\item{valueAxisX}{\linkS4class{ValueAxis}.
Used by XY chart only. X axis of trend line.
Will use first X axis of the chart if not set any.
You can use a reference to the value axis object or id of value axis.}

\item{...}{other properties of TrendLine.}
}
\value{
(possibly updated) .Object of class \linkS4class{TrendLine}.
}
\description{
Uses the constructor to create the object
or update an existing one with the setters.
}
\examples{
new("TrendLine", initialValue = 1, finalValue = 11)

# Other example
valueAxis <- valueAxis(title = "Hello !", axisTitleOffset = 12)
new("TrendLine", valueAxis = valueAxis)

trendLine(initialValue = 1, finalValue = 11)
setInitialValue(.Object = trendLine(), initialValue = 16)
setInitialXValue(.Object = trendLine(), initialXValue = 16)
setFinalValue(.Object = trendLine(), finalValue = 16)
setFinalXValue(.Object = trendLine(), finalXValue = 16)
setValueAxis(.Object = trendLine(), id = "valueAxis-1",
             title = "Hello !", axisTitleOffset = 12)
# equival to:
valueAxis_obj <- valueAxis(id = "valueAxis-1", title = "Hello !", axisTitleOffset = 12)
trendLine(valueAxis = valueAxis_obj)
# or...
trendLine(valueAxis = "valueAxis-1")
# valid if and only if 'valueAxis_obj' has already been added to the chart

setValueAxisX(.Object = trendLine(), id = "valueAxisX-1",
              title = "Hello !", axisTitleOffset = 12)
# equival to:
valueAxisX_obj <- valueAxis(id = "valueAxisX-1", title = "Hello !", axisTitleOffset = 12)
trendLine(valueAxisX = valueAxisX_obj)
# or...
trendLine(valueAxisX = "valueAxisX-1")
# valid if and only if 'valueAxisX_obj' has already been added to the chart

}
