% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quanteda_options.R
\name{quanteda_options}
\alias{quanteda_options}
\title{get or set package options for quanteda}
\usage{
quanteda_options(..., reset = FALSE)
}
\arguments{
\item{...}{options to be set, as key-value pair, same as \code{\link{options}}}

\item{reset}{logical; if \code{TRUE}, reset all \pkg{quanteda} options to their 
default values}
}
\value{
When called using a \code{key = value} pair (where \code{key} can be a label or 
  quoted character name)), the option is set and \code{TRUE} is returned invisibly.

  When called with no arguments, a named list of the package options is returned.
  
  When called with \code{reset = TRUE} as an argument, all arguments are options 
  are reset to their default values, and \code{TRUE} is returned invisibly.
}
\description{
Get or set global options affecting functions across \pkg{quatneda}.
}
\details{
Currently available options are:
\describe{
\item{\code{verbose}}{logical; if \code{TRUE} then use this as the default
   for all functions with a \code{verbose} argument}
\item{\code{threads}}{integer; specifies the number of threads to use in
   use this as the setting in all functions that uee parallelization}
}
}
\examples{
quanteda_options()
quanteda_options(verbose = FALSE)
quanteda_options("verbose" = FALSE)
quanteda_options("threads")
\dontrun{
quanteda_options(reset = TRUE) 
}
}
