% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show.R
\name{showQspray}
\alias{showQspray}
\title{Print a 'qspray' object}
\usage{
showQspray(showMonomial, compact = FALSE, multiplication = "*")
}
\arguments{
\item{showMonomial}{a function which takes as argument a sequence of 
exponents and which returns a string representing the corresponding 
monomial}

\item{compact}{a Boolean value; if \code{TRUE}, then the \code{+} sign 
and the \code{-} sign will not be surrounded by spaces}

\item{multiplication}{used to separate the coefficient and the monomial 
within a term}
}
\value{
A function which prints a \code{qspray} object.
}
\description{
Prints a \code{qspray} object given a function which prints 
  the monomials.
}
\note{
The function returned by this function can be used as the option 
  \code{"showQspray"} in the \code{\link{showQsprayOption<-}} function.
  But one generally prefers to use \code{\link{showQsprayX1X2X3}} or 
  \code{\link{showQsprayXYZ}} instead, which are both built with 
  \code{showQspray}.
}
\examples{
set.seed(3141)
( qspray <- rQspray() )
f <- showQspray(showMonomialX1X2X3("X"), compact = TRUE)
f(qspray)
# this is equivalent to:
f <- showQsprayX1X2X3("X", compact = TRUE)
f(qspray)
# if you want to adopt this way to show a qspray, use 
# the setter function \code{\link{showQsprayOption<-}}: 
showQsprayOption(qspray, "showQspray") <- 
  showQsprayX1X2X3("X", compact = TRUE)
qspray
# then this show option will be preserved by some operations on the qspray:
qspray^2
}
\seealso{
\code{\link{showQsprayX1X2X3}}, \code{\link{showQsprayXYZ}}, 
  \code{\link{showQsprayOption<-}}.
}
