# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Reproductive value
#'
#' Computes the reproductive value
#' 
#' @template ped-arg
#' @template reference-arg
#' @template nameto-arg
#' @template target-arg
#' @param enable_correction Correct reproductive values.
#' @return The input dataframe, plus an additional column with reproductive values for the reference and target populations assumed.
#' @references
#' Hunter DC et al. 2019. Pedigree-based estimation of reproductive value. Journal of Heredity 110 (4): 433-444
reproductive_value <- function(ped, reference, name_to, target = NULL, enable_correction = TRUE) {
    .Call(`_purgeR_reproductive_value`, ped, reference, name_to, target, enable_correction)
}

#' Inbreeding coefficient
#'
#' Computes the standard inbreeding coefficient (\emph{F}).
#' This is the probability that two alleles on a locus are identical by descent (Falconer and Mackay 1996, Wright 1922), calculated from the genealogical coancestry matrix (Malécot 1948).
#' 
#' @template ped-arg
#' @template nameto-arg
#' @return The input dataframe, plus an additional column named "F" with individual inbreeding coefficient values.
#' @encoding UTF-8
#' @references
#' \itemize{
#'   \item{Falconer DS, Mackay TFC. 1996. Introduction to Quantitative Genetics. 4th edition. Longman, Essex, U.K.}
#'   \item{Malécot G, 1948. Les Mathématiques de l’hérédité. Masson & Cie., Paris.}
#'   \item{Wright S. 1922. Coefficients of inbreeding and relationship. The American Naturalist 56: 330-338.}
#'}
F <- function(ped, name_to) {
    .Call(`_purgeR_F`, ped, name_to)
}

#' Ancestral inbreeding coefficient
#'
#' Computes the ancestral inbreeding coefficient (\emph{Fa}).
#' This is the probability that an allele has been in homozygosity in at least one ancestor (Ballou 1997).
#' A genedrop approach is included to compute unbiased estimates of \emph{Fa} (Baumung et al. 2015).
#' 
#' @template ped-arg
#' @template nameto-arg
#' @template Fi-arg
#' @param genedrop Number of genedrop iterations to run. If set to zero (as default), Ballou's Fa is computed.
#' @template seed-arg
#' @return The input dataframe, plus an additional column named "Fa" with individual ancestral inbreeding coefficient values.
#' @references
#' \itemize{
#'   \item{Ballou JD. 1997. Ancestral inbreeding only minimally affects inbreeding depression in mammalian populations. J Hered. 88:169–178.}
#'   \item{Baumung et al. 2015. GRAIN: A computer program to calculate ancestral and partial inbreeding coefficients using a gene dropping approach. Journal of Animal Breeding and Genetics 132: 100-108.}
#'}
Fa <- function(ped, Fi, name_to, genedrop = 0L, seed = NULL) {
    .Call(`_purgeR_Fa`, ped, Fi, name_to, genedrop, seed)
}

#' Purged inbreeding coefficient
#'
#' Computes the purged inbreeding coefficient (\emph{g}).
#' This is the probability that two alleles on a locus are identical by descent,
#' but relative to deleterious recessive alleles (García-Dorado 2012). The reduction
#' in \emph{g} relative to standard inbreeding (\emph{F}) is given by an effective purging
#' coefficient (\emph{d}), that measures the strength of the deleterious recessive
#' component in the genome. The coefficient \emph{g} is computed following the methods
#' for pedigrees in García-Dorado (2012) and García-Dorado et al. (2016).
#' 
#' @template ped-arg
#' @param d Purging coefficient (taking values between 0.0 and 0.5).
#' @template nameto-arg
#' @template Fi-arg
#' @return The input dataframe, plus an additional column named "g" followed by the purging coefficient, containing purged inbreeding coefficient values.
#' @encoding UTF-8
#' @references
#' \itemize{
#'   \item{García-Dorado. 2012. Understanding and predicting the fitness decline of shrunk populations: Inbreeding, purging, mutation, and standard selection. Genetics 190: 1-16.}
#'   \item{García-Dorado et al. 2016. Predictive model and software for inbreeding-purging analysis of pedigreed populations. G3 6: 3593-3601.}
#' }
g <- function(ped, d, Fi, name_to) {
    .Call(`_purgeR_g`, ped, d, Fi, name_to)
}

#' Deviation from Hardy-Weinberg equilibrium
#'
#' Computes the deviation from Hardy-Weinberg equilibrium following Caballero and Toro (2000).
#' 
#' @template ped-arg
#' @template reference-arg
#' @return A numeric value indicating the deviation from Hardy-Weinberg equilibrium.
#' @seealso \code{\link{pop_Ne}}
#' @references
#' \itemize{
#'   \item{Caballero A, Toro M. 2000. Interrelations between effective population size and other pedigree tools for the management of conserved populations. Genet. Res. 75: 331-343.}
#' }
hwd <- function(ped, reference = NULL) {
    .Call(`_purgeR_hwd`, ped, reference)
}

#' Opportunity of purging
#'
#' The potential reduction in individual inbreeding load can be
#' estimated by means of the opportunity of purging (\emph{O}) and expressed
#' opportunity of purging (\emph{Oe}) parameters described by Gulisija
#' and Crow (2007). Whereas \emph{O} relates to the total potential reduction
#' of the inbreeding load in an individual, as a consequence of it having
#' inbred ancestors, \emph{Oe} relates to the expressed potential reduction of the
#' inbreeding load. In both cases, these measures are referred to fully recessive,
#' high effect size alleles (e.g. lethals). For complex pedigrees, involving more than one
#' autozygous individual per path from a reference individual to an
#' ancestor, these estimates are estimated following an heuristic approach
#' (see details below).
#' 
#' In simple pedigrees, the opportunity of purging (\emph{O}) and the expressed
#' opportunity of purging (\emph{Oe}) are estimated as in Gulisija and Crow (2007).
#' For complex pedigrees involving more than one autozygous individual per
#' path from an individual to an ancestor, \emph{O} and \emph{Oe} in the closer ancestors
#' need to be discounted for what was already accounted for in their predecessors.
#' To solve this problem, Gulisija and Crow (2007) provide expression to 
#' correct \emph{O} and \emph{Oe} (see equations 21 and 22 in the manuscript).
#' 
#' Here, an heuristic approach is used to prevent the inflation of \emph{O} and \emph{Oe},
#' and avoid the use of additional looped expressions that may result in an
#' excessive computational cost. To do so, when using \code{ip_op(complex = TRUE)}
#' only the contribution of the most recent ancestors in a path will be considered.
#' This may not provide exact values of \emph{O} and \emph{Oe}, but we expect little bias, since
#' more distant ancestors also contribute lesser to \emph{O} and \emph{Oe}.
#' 
#' @template ped-arg
#' @param pi Partial inbreeding matrix
#' @template Fi-arg
#' @param name_O A string naming the new output column for total opportunity of purging (defaults to "O") 
#' @param name_Oe A string naming the new output column for the expressed opportunity of purging (defaults to "Oe")
#' @param sufix A string naming the sufix for non-corrected O and Oe measures
#' @param compute_O Enable computation of total opportunity of purging (false by default)
#' @return The input dataframe, plus two additional column named "O" and "Oe", containing total and expressed opportunity of purging measures.
#' @encoding UTF-8
#' @references
#' \itemize{
#'   \item{Gulisija D, Crow JF. 2007. Inferring purging from pedigree data. Evolution 61(5): 1043-1051.}
#' }
op <- function(ped, pi, Fi, name_O, name_Oe, sufix, compute_O = FALSE) {
    .Call(`_purgeR_op`, ped, pi, Fi, name_O, name_Oe, sufix, compute_O)
}

#' Partial inbreeding coefficient (core function)
#'
#' Computes partial inbreeding coefficients, Fi(j).
#' A coefficient Fi(j) can be read as the probability of individual i being
#' homozygous for alleles derived from ancestor j
#' 
#' @name Fij_core_i_cpp
#' @param dam Vector of dam ids.
#' @param sire Vector of sire ids.
#' @param anc_idx Index of ancestors.
#' @param Fi Vector of inbreeding coefficients.
#' @param mapa Map of ancestors
#' @param genedrop Enable genedrop simulation
#' @template seed-arg
#' @return A matrix of partial inbreeding coefficients. Fi(j) values can thus be read from row i and column j.
Fij_core_i_cpp <- function(dam, sire, anc_idx, mapa, Fi, genedrop = 0L, seed = NULL) {
    .Call(`_purgeR_Fij_core_i_cpp`, dam, sire, anc_idx, mapa, Fi, genedrop, seed)
}

#' Search and individuals' ancestors
#'
#' Recursive function that gathers all founders and ancestors for a given individual
#' 
#' @name search_ancestors
#' @template ped-arg
#' @param i Reference individual (its index, not id).
#' @param fnd Vector of founders (to be returned as reference).
#' @param anc Vector of ancestors (to be returned as reference).
#' @return The sampled allele.
NULL

#' Sample dam or sire inherited allele
#'
#' Given two alleles (one from dam, the other from sire), it samples one at random.
#' 
#' @name sample_allele
#' @param dam_al Dam allele.
#' @param sire_al Sire allele.
#' @return The sampled allele.
NULL

#' Individuals to be evaluated in purging analyses
#'
#' Returns a boolean vector indicating what individuals are suitable for purging analyses, given a measure of fitness.
#' Individuals with NA values of fitness, and that do not have descendants with non-NA fitness values, are excluded.
#' 
#' @template ped-arg
#' @template reference-arg
#' @param rp_idx Vector containing the indexes of individuals of the RP
#' @param nboot Number of bootstrap iterations (for computing Ng).
#' @template seed-arg
#' @param skip_Ng Skip Ng computation or not (FALSE by default).
#' @return Boolean vector indicating what individuals will be evaluated.
ancestors <- function(ped, reference, rp_idx, nboot = 10000L, seed = NULL, skip_Ng = FALSE) {
    .Call(`_purgeR_ancestors`, ped, reference, rp_idx, nboot, seed, skip_Ng)
}

