% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper-functions.R
\name{gibbs_logistic}
\alias{gibbs_logistic}
\title{Fit logistic regression model}
\usage{
gibbs_logistic(
  formula,
  data,
  m = 100,
  burn = 0,
  thin = 1,
  mu0 = NULL,
  sigma0 = NULL,
  eta_start = NULL,
  proposal_sd = NULL,
  verbose = FALSE,
  display_progress = FALSE
)
}
\arguments{
\item{formula}{An object of class \code{\link[stats:formula]{formula}}: a symbolic
description of the model to be fitted.}

\item{data}{An optional data frame containing the variables in the model.}

\item{m}{The number of iterations to run the Gibbs sampler (default: \code{100}).}

\item{burn}{The number of iterations to discard as the burn-in period
(default: \code{0}).}

\item{thin}{The period of iterations to keep after the burn-in period
(default: \code{1}).}

\item{mu0}{An optional p x 1 mean vector for the prior on the regression
coefficients. See 'Details'.}

\item{sigma0}{A p x p variance-covariance matrix for the prior on the
regression coefficients. See 'Details'.}

\item{eta_start}{A p x 1 vector of starting values for the
regression coefficients.}

\item{proposal_sd}{The proposal standard deviations for drawing the
regression coefficients, N(0, \code{proposal_sd}(j)), \eqn{j = 1, \ldots, p}
(default: \code{2.38} for all coefficients).}

\item{verbose}{Should parameter draws be output during sampling? (default:
\code{FALSE}).}

\item{display_progress}{Show progress bar? (default: \code{FALSE}). Do not use
with \code{verbose = TRUE}.}
}
\value{
An object of class \linkS4class{Logistic}.
}
\description{
\code{gibbs_logistic()} is used to fit a Bayesian logistic regression model
using Gibbs sampling.
}
\details{
For \code{mu0}, by default, we use a vector of \eqn{p} \code{0}s for \eqn{p}
regression coefficients.

For \code{sigma0}, by default, we use a \eqn{p} x \eqn{p} diagonal matrix
with diagonal elements (variances) of \code{6.25}.
}
\examples{
data(mtcars)
m1 <- gibbs_logistic(vs ~ hp, data = mtcars)

}
\seealso{
Other Gibbs sampler: 
\code{\link{gibbs_mlr}()},
\code{\link{gibbs_sldax}()}
}
\concept{Gibbs sampler}
