% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ma_d.R, R/ma_d_ad.R, R/ma_d_bb.R, R/ma_d_ic.R
\name{ma_d}
\alias{ma_d}
\alias{ma_d_ad}
\alias{ma_d_bb}
\alias{ma_d_barebones}
\alias{ma_d_ic}
\title{Meta-analysis of \emph{d} values}
\usage{
ma_d(
  d,
  n1,
  n2 = NULL,
  n_adj = NULL,
  sample_id = NULL,
  citekey = NULL,
  treat_as_r = FALSE,
  ma_method = c("bb", "ic", "ad"),
  ad_type = c("tsa", "int"),
  correction_method = "auto",
  group_id = NULL,
  group1 = NULL,
  group2 = NULL,
  group_order = NULL,
  construct_y = NULL,
  facet_y = NULL,
  measure_y = NULL,
  construct_order = NULL,
  wt_type = c("n_effective", "sample_size", "inv_var_mean", "inv_var_sample", "DL",
    "HE", "HS", "SJ", "ML", "REML", "EB", "PM"),
  correct_bias = TRUE,
  correct_rel = NULL,
  correct_rGg = FALSE,
  correct_ryy = TRUE,
  correct_rr = NULL,
  correct_rr_g = TRUE,
  correct_rr_y = TRUE,
  indirect_rr = NULL,
  indirect_rr_g = TRUE,
  indirect_rr_y = TRUE,
  rGg = NULL,
  pi = NULL,
  pa = NULL,
  ryy = NULL,
  ryy_restricted = TRUE,
  ryy_type = "alpha",
  k_items_y = NULL,
  uy = NULL,
  uy_observed = TRUE,
  sign_rz = NULL,
  sign_rgz = 1,
  sign_ryz = 1,
  moderators = NULL,
  cat_moderators = TRUE,
  moderator_type = c("simple", "hierarchical", "none"),
  supplemental_ads = NULL,
  data = NULL,
  control = control_psychmeta(),
  ...
)

ma_d_ad(
  ma_obj,
  ad_obj_g = NULL,
  ad_obj_y = NULL,
  correction_method = "auto",
  use_ic_ads = c("tsa", "int"),
  correct_rGg = FALSE,
  correct_ryy = TRUE,
  correct_rr_g = TRUE,
  correct_rr_y = TRUE,
  indirect_rr_g = TRUE,
  indirect_rr_y = TRUE,
  sign_rgz = 1,
  sign_ryz = 1,
  control = control_psychmeta(),
  ...
)

ma_d_bb(
  d,
  n1,
  n2 = rep(NA, length(d)),
  n_adj = NULL,
  sample_id = NULL,
  citekey = NULL,
  wt_type = c("n_effective", "sample_size", "inv_var_mean", "inv_var_sample", "DL",
    "HE", "HS", "SJ", "ML", "REML", "EB", "PM"),
  correct_bias = TRUE,
  moderators = NULL,
  cat_moderators = TRUE,
  moderator_type = c("simple", "hierarchical", "none"),
  data = NULL,
  control = control_psychmeta(),
  ...
)

ma_d_ic(
  d,
  n1,
  n2 = NULL,
  n_adj = NULL,
  sample_id = NULL,
  citekey = NULL,
  treat_as_r = FALSE,
  wt_type = c("n_effective", "sample_size", "inv_var_mean", "inv_var_sample", "DL",
    "HE", "HS", "SJ", "ML", "REML", "EB", "PM"),
  correct_bias = TRUE,
  correct_rGg = FALSE,
  correct_ryy = TRUE,
  correct_rr_g = FALSE,
  correct_rr_y = TRUE,
  indirect_rr_g = TRUE,
  indirect_rr_y = TRUE,
  rGg = NULL,
  pi = NULL,
  pa = NULL,
  ryy = NULL,
  ryy_restricted = TRUE,
  ryy_type = "alpha",
  k_items_y = NULL,
  uy = NULL,
  uy_observed = TRUE,
  sign_rgz = 1,
  sign_ryz = 1,
  moderators = NULL,
  cat_moderators = TRUE,
  moderator_type = c("simple", "hierarchical", "none"),
  supplemental_ads_y = NULL,
  data = NULL,
  control = control_psychmeta(),
  ...
)
}
\arguments{
\item{d}{Vector or column name of observed \emph{d} values.}

\item{n1}{Vector or column name of sample sizes.}

\item{n2}{Vector or column name of sample sizes.}

\item{n_adj}{Optional: Vector or column name of sample sizes adjusted for sporadic artifact corrections.}

\item{sample_id}{Optional vector of identification labels for samples/studies in the meta-analysis.}

\item{citekey}{Optional vector of bibliographic citation keys for samples/studies in the meta-analysis (if multiple citekeys pertain to a given effect size, combine them into a single string entry with comma delimiters (e.g., "citkey1,citekey2").}

\item{treat_as_r}{Logical scalar determining whether \emph{d} values are to be meta-analyzed as \emph{d} values (\code{FALSE}; default) or whether they should be meta-analyzed as correlations and have the final results converted to the \emph{d} metric (\code{TRUE}).}

\item{ma_method}{Method to be used to compute the meta-analysis: "bb" (barebones), "ic" (individual correction), or "ad" (artifact distribution).}

\item{ad_type}{For when ma_method is "ad", specifies the type of artifact distribution to use: "int" or "tsa".}

\item{correction_method}{Character scalar or a matrix with \code{group_id} levels as row names and \code{construct_y} levels as column names.
When ma_method is "ad", select one of the following methods for correcting artifacts: "auto", "meas", "uvdrr", "uvirr", "bvdrr", "bvirr",
"rbOrig", "rb1Orig", "rb2Orig", "rbAdj", "rb1Adj", and "rb2Adj".
(note: "rb1Orig", "rb2Orig", "rb1Adj", and "rb2Adj" can only be used when Taylor series artifact distributions are provided and "rbOrig" and "rbAdj" can only
be used when interactive artifact distributions are provided). See "Details" of \code{\link{ma_d_ad}} for descriptions of the available methods.}

\item{group_id}{Vector of group comparison IDs (e.g., Treatment1-Control, Treatment2-Control).
The \code{group_id} argument supersedes the \code{group1} and \code{group2} arguments.
If \code{group_id} is not \code{NULL}, the values supplied to the \code{group_order} argument must correspond to \code{group_id} values.}

\item{group1, group2}{Vector of group identification labels (e.g., Treatment1, Treatment2, Control)}

\item{group_order}{Optional vector indicating the order in which (1) \code{group1} and \code{group2} values or (2) \code{group_ids} should be arranged.
If \code{group_order} is \code{NULL}, the order of group pairings will be determined internally using alpha-numeric ordering.}

\item{construct_y}{Vector of construct names for construct designated as "Y".}

\item{facet_y}{Vector of facet names for constructs designated as "Y".
Facet names "global", "overall", and "total" are reserved to indicate observations that represent effect sizes that have already been composited or that represent construct-level measurements rather than facet-level measurements.
To avoid double-compositing, any observation with one of these reserved names will only be eligible for auto-compositing with other such observations and will not be combined with narrow facets.}

\item{measure_y}{Vector of names for measures associated with constructs designated as "Y".}

\item{construct_order}{Vector indicating the order in which Y variables should be arranged.}

\item{wt_type}{Type of weight to use in the meta-analysis: options are "n_effective" (effective sample size), "sample_size", "inv_var_mean" (inverse variance computed using mean effect size), and
"inv_var_sample" (inverse variance computed using sample-specific effect sizes). Supported options borrowed from metafor are "DL", "HE", "HS", "SJ", "ML", "REML", "EB", and "PM"
(see \pkg{metafor} documentation for details about the \pkg{metafor} methods).}

\item{correct_bias}{Logical scalar that determines whether to correct correlations for small-sample bias (\code{TRUE}) or not (\code{FALSE}).}

\item{correct_rel}{Optional named vector that supersedes \code{correct_rGg} and \code{correct_ryy}. Names should correspond to construct names in \code{group_id} and \code{construct_y} to determine which constructs should be corrected for unreliability.}

\item{correct_rGg}{Logical scalar or vector that determines whether to correct the grouping variable variable for measurement error (\code{TRUE}) or not (\code{FALSE}).}

\item{correct_ryy}{Logical scalar or vector that determines whether to correct the Y variable for measurement error (\code{TRUE}) or not (\code{FALSE}).}

\item{correct_rr}{Optional named vector that supersedes \code{correct_rr_g} and \code{correct_rr_y}. Names should correspond to construct names in \code{group_id} and \code{construct_y} to determine which constructs should be corrected for range restriction.}

\item{correct_rr_g}{Logical scalar or vector or column name determining whether each \emph{d} value should be corrected for range restriction in the grouping variable (\code{TRUE}) or not (\code{FALSE}).}

\item{correct_rr_y}{Logical scalar or vector or column name determining whether each \emph{d} should be corrected for range restriction in Y (\code{TRUE}) or not (\code{FALSE}).}

\item{indirect_rr}{Optional named vector that supersedes \code{indirect_rr_g} and \code{indirect_rr_y}. Names should correspond to construct names in \code{group_id} and \code{construct_y} to determine which constructs should be corrected for indirect range restriction.}

\item{indirect_rr_g}{Logical vector or column name determining whether each \emph{d} should be corrected for indirect range restriction in the grouping variable (\code{TRUE}) or not (\code{FALSE}).
Superseded in evaluation by \code{correct_rr_g} (i.e., if \code{correct_rr_g} == \code{FALSE}, the value supplied for \code{indirect_rr_g} is disregarded).}

\item{indirect_rr_y}{Logical vector or column name determining whether each \emph{d} should be corrected for indirect range restriction in Y (\code{TRUE}) or not (\code{FALSE}).
Superseded in evaluation by \code{correct_rr_y} (i.e., if \code{correct_rr_y} == \code{FALSE}, the value supplied for \code{indirect_rr_y} is disregarded).}

\item{rGg}{Vector or column name of reliability estimates for X.}

\item{pi}{Scalar or vector containing the restricted-group proportions of group membership. If a vector, it must either (1) have as many elements as there are \emph{d} values or (2) be named so as to match with levels of the \code{group_id} argument.}

\item{pa}{Scalar or vector containing the unrestricted-group proportions of group membership (default = .5). If a vector, it must either (1) have as many elements as there are \emph{d} values or (2) be named so as to match with levels of the \code{group_id} argument.}

\item{ryy}{Vector or column name of reliability estimates for Y.}

\item{ryy_restricted}{Logical vector or column name determining whether each element of \code{ryy} is an incumbent reliability (\code{TRUE}) or an applicant reliability (\code{FALSE}).}

\item{ryy_type}{String vector identifying the types of reliability estimates supplied (e.g., "alpha", "retest", "interrater_r", "splithalf"). See the documentation for \code{\link{ma_r}} for a full list of acceptable reliability types.}

\item{k_items_y}{Numeric vector identifying the number of items in each scale.}

\item{uy}{Vector or column name of u ratios for Y.}

\item{uy_observed}{Logical vector or column name determining whether each element of \code{uy} is an observed-score u ratio (\code{TRUE}) or a true-score u ratio (\code{FALSE}).}

\item{sign_rz}{Optional named vector that supersedes \code{sign_rgz} and \code{sign_ryz}. Names should correspond to construct names in \code{group_id} and \code{construct_y} to determine the sign of each construct's relationship with the selection mechanism.}

\item{sign_rgz}{Sign of the relationship between X and the selection mechanism (for use with bvirr corrections only).}

\item{sign_ryz}{Sign of the relationship between Y and the selection mechanism (for use with bvirr corrections only).}

\item{moderators}{Matrix or column names of moderator variables to be used in the meta-analysis (can be a vector in the case of one moderator).}

\item{cat_moderators}{Logical scalar or vector identifying whether variables in the \code{moderators} argument are categorical variables (\code{TRUE}) or continuous variables (\code{FALSE}).}

\item{moderator_type}{Type of moderator analysis: "none" means that no moderators are to be used, "simple" means that moderators are to be examined one at a time,
"hierarchical" means that all possible combinations and subsets of moderators are to be examined, and "all" means that simple and hierarchical moderator analyses are to be performed.}

\item{supplemental_ads}{Named list (named according to the constructs included in the meta-analysis) of supplemental artifact distribution information from studies not included in the meta-analysis. This is a list of lists, where the elements of a list associated with a construct are named like the arguments of the \code{create_ad()} function.}

\item{data}{Data frame containing columns whose names may be provided as arguments to vector arguments and/or moderators.}

\item{control}{Output from the \code{control_psychmeta()} function or a list of arguments controlled by the \code{control_psychmeta()} function. Ellipsis arguments will be screened for internal inclusion in \code{control}.}

\item{...}{Further arguments to be passed to functions called within the meta-analysis.}

\item{ma_obj}{For \code{ma_d_ad} only: Meta-analysis object of correlations or \emph{d} values (regardless of input metric, output metric will be \emph{d}).}

\item{ad_obj_g}{For \code{ma_d_ad} only: Artifact-distribution object for the grouping variable (output of the \code{link{create_ad}} or \code{link{create_ad_group}} functions).
If ma_obj is of the class \code{ma_master} (i.e., the output of \code{\link{ma_r}} or \code{\link{ma_d}}), the object supplied for
\code{ad_obj_g} must be a named list of artifact distributions with names.
corresponding to the "X" constructs in the meta-analyses contained within \code{ma_obj}.}

\item{ad_obj_y}{For \code{ma_d_ad} only: AArtifact-distribution object for the Y variable (output of the \code{create_ad} function).
If ma_obj is of the class \code{ma_master}, the object supplied for \code{ad_obj_y} must be a named list of artifact distributions with names
corresponding to the "Y" constructs in the meta-analyses contained within \code{ma_obj}.}

\item{use_ic_ads}{For \code{ma_d_ad} only: Determines whether artifact distributions should be extracted from the individual correction results in \code{ma_obj}.
Only evaluated when \code{ad_obj_g} or \code{ad_obj_y} is NULL and \code{ma_obj} does not contain individual correction results.
Use one of the following commands: \code{tsa} to use the Taylor series method or \code{int} to use the interactive method.}

\item{supplemental_ads_y}{For \code{ma_d_ic} only: List supplemental artifact distribution information from studies not included in the meta-analysis. The elements of this list are named like the arguments of the \code{create_ad()} function.}
}
\value{
A nested tabular object of the class "ma_psychmeta".
Components of output tables for bare-bones meta-analyses:
\itemize{
\item{\code{Pair_ID}}{\cr Unique identification number for each construct-contrast pairing.}
\item{\code{group_contrast}}{\cr Name of the variable analyzed as the group-contrast variable.}
\item{\code{construct_y}}{\cr Name of the variable analyzed as construct Y.}
\item{\code{analysis_id}}{\cr Unique identification number for each analysis.}
\item{\code{analysis_type}}{\cr Type of moderator analyses: Overall, Simple Moderator, or Hierarchical Moderator.}
\item{\code{k}}{\cr Number of effect sizes meta-analyzed.}
\item{\code{N}}{\cr Total sample size of all effect sizes in the meta-analysis.}
\item{\code{mean_d}}{\cr Mean observed \emph{d} value.}
\item{\code{var_d}}{\cr Weighted variance of observed \emph{d} values.}
\item{\code{var_e}}{\cr Predicted sampling-error variance of observed \emph{d} values.}
\item{\code{var_res}}{\cr Variance of observed \emph{d} values after removing predicted sampling-error variance.}
\item{\code{sd_d}}{\cr Square root of \code{var_r}.}
\item{\code{se_d}}{\cr Standard error of \code{mean_d}.}
\item{\code{sd_e}}{\cr Square root of \code{var_e}.}
\item{\code{sd_res}}{\cr Square root of \code{var_res}.}
\item{\code{CI_LL_XX}}{\cr Lower limit of the confidence interval around \code{mean_d}, where "XX" represents the confidence level as a percentage.}
\item{\code{CI_UL_XX}}{\cr Upper limit of the confidence interval around \code{mean_d}, where "XX" represents the confidence level as a percentage.}
\item{\code{CR_LL_XX}}{\cr Lower limit of the credibility interval around \code{mean_d}, where "XX" represents the credibility level as a percentage.}
\item{\code{CR_UL_XX}}{\cr Upper limit of the credibility interval around \code{mean_d}, where "XX" represents the credibility level as a percentage.}
}

Components of output tables for individual-correction meta-analyses:
\itemize{
\item{\code{pair_id}}{\cr Unique identification number for each construct-contrast pairing.}
\item{\code{group_contrast}}{\cr Name of the variable analyzed as the group-contrast variable.}
\item{\code{construct_y}}{\cr Name of the variable analyzed as construct Y.}
\item{\code{analysis_id}}{\cr Unique identification number for each analysis.}
\item{\code{analysis_type}}{\cr Type of moderator analyses: Overall, Simple Moderator, or Hierarchical Moderator.}
\item{\code{k}}{\cr Number of effect sizes meta-analyzed.}
\item{\code{N}}{\cr Total sample size of all effect sizes in the meta-analysis.}
\item{\code{mean_d}}{\cr Mean observed \emph{d} value.}
\item{\code{var_d}}{\cr Weighted variance of observed \emph{d} values.}
\item{\code{var_e}}{\cr Predicted sampling-error variance of observed \emph{d} values.}
\item{\code{var_res}}{\cr Variance of observed \emph{d} values after removing predicted sampling-error variance.}
\item{\code{sd_d}}{\cr Square root of \code{var_r}.}
\item{\code{se_d}}{\cr Standard error of \code{mean_d}.}
\item{\code{sd_e}}{\cr Square root of \code{var_e}.}
\item{\code{sd_res}}{\cr Square root of \code{var_res}.}
\item{\code{mean_delta}}{\cr Mean artifact-corrected \emph{d} value.}
\item{\code{var_d_c}}{\cr Variance of artifact-corrected \emph{d} values.}
\item{\code{var_e_c}}{\cr Predicted sampling-error variance of artifact-corrected \emph{d} values.}
\item{\code{var_delta}}{\cr Variance of artifact-corrected \emph{d} values after removing predicted sampling-error variance.}
\item{\code{sd_d_c}}{\cr Square root of \code{var_r_c}.}
\item{\code{se_d_c}}{\cr Standard error of \code{mean_delta}.}
\item{\code{sd_e_c}}{\cr Square root of \code{var_e_c}.}
\item{\code{sd_delta}}{\cr Square root of \code{var_delta}.}
\item{\code{CI_LL_XX}}{\cr Lower limit of the confidence interval around \code{mean_delta}, where "XX" represents the confidence level as a percentage.}
\item{\code{CI_UL_XX}}{\cr Upper limit of the confidence interval around \code{mean_delta}, where "XX" represents the confidence level as a percentage.}
\item{\code{CR_LL_XX}}{\cr Lower limit of the credibility interval around \code{mean_delta}, where "XX" represents the credibility level as a percentage.}
\item{\code{CR_UL_XX}}{\cr Upper limit of the credibility interval around \code{mean_delta}, where "XX" represents the credibility level as a percentage.}
}

Components of output tables for artifact-distribution meta-analyses:
\itemize{
\item{\code{pair_id}}{\cr Unique identification number for each construct-contrast pairing.}
\item{\code{group_contrast}}{\cr Name of the variable analyzed as the group-contrast variable.}
\item{\code{construct_y}}{\cr Name of the variable analyzed as construct Y.}
\item{\code{analysis_id}}{\cr Unique identification number for each analysis.}
\item{\code{analysis_type}}{\cr Type of moderator analyses: Overall, Simple Moderator, or Hierarchical Moderator.}
\item{\code{k}}{\cr Number of effect sizes meta-analyzed.}
\item{\code{N}}{\cr Total sample size of all effect sizes in the meta-analysis.}
\item{\code{mean_d}}{\cr Mean observed \emph{d} value.}
\item{\code{var_d}}{\cr Weighted variance of observed \emph{d} values.}
\item{\code{var_e}}{\cr Predicted sampling-error variance of observed \emph{d} values.}
\item{\code{var_art}}{\cr Amount of variance in observed \emph{d} values that is attributable to measurement-error and range-restriction artifacts.}
\item{\code{var_pre}}{\cr Total predicted artifactual variance (i.e., the sum of \code{var_e} and \code{var_art}).}
\item{\code{var_res}}{\cr Variance of observed \emph{d} values after removing predicted sampling-error variance and predicted artifact variance.}
\item{\code{sd_d}}{\cr Square root of \code{var_d}.}
\item{\code{se_d}}{\cr Standard error of \code{mean_d}.}
\item{\code{sd_e}}{\cr Square root of \code{var_e}.}
\item{\code{sd_art}}{\cr Square root of \code{var_art}.}
\item{\code{sd_pre}}{\cr Square root of \code{var_pre}.}
\item{\code{sd_res}}{\cr Square root of \code{var_res}.}
\item{\code{mean_delta}}{\cr Mean artifact-corrected \emph{d} value.}
\item{\code{var_d}}{\cr Weighted variance of observed \emph{d} values corrected to the metric of delta.}
\item{\code{var_e}}{\cr Predicted sampling-error variance of observed \emph{d} values corrected to the metric of delta.}
\item{\code{var_art}}{\cr Amount of variance in observed \emph{d} values that is attributable to measurement-error and range-restriction artifacts corrected to the metric of delta.}
\item{\code{var_pre}}{\cr Total predicted artifactual variance (i.e., the sum of \code{var_e} and \code{var_art}) corrected to the metric of delta.}
\item{\code{var_delta}}{\cr Variance of artifact-corrected \emph{d} values after removing predicted sampling-error variance and predicted artifact variance.}
\item{\code{sd_d}}{\cr Square root of \code{var_d} corrected to the metric of delta.}
\item{\code{se_d}}{\cr Standard error of \code{mean_d} corrected to the metric of delta.}
\item{\code{sd_e}}{\cr Square root of \code{var_e} corrected to the metric of delta.}
\item{\code{sd_art}}{\cr Square root of \code{var_art} corrected to the metric of delta.}
\item{\code{sd_pre}}{\cr Square root of \code{var_pre} corrected to the metric of delta.}
\item{\code{sd_delta}}{\cr Square root of \code{var_delta}.}
\item{\code{CI_LL_XX}}{\cr Lower limit of the confidence interval around \code{mean_delta}, where "XX" represents the confidence level as a percentage.}
\item{\code{CI_UL_XX}}{\cr Upper limit of the confidence interval around \code{mean_delta}, where "XX" represents the confidence level as a percentage.}
\item{\code{CR_LL_XX}}{\cr Lower limit of the credibility interval around \code{mean_delta}, where "XX" represents the credibility level as a percentage.}
\item{\code{CR_UL_XX}}{\cr Upper limit of the credibility interval around \code{mean_delta}, where "XX" represents the credibility level as a percentage.}
}
}
\description{
The \code{ma_r_bb}, \code{ma_r_ic}, and \code{ma_r_ad} functions implement bare-bones, individual-correction, and artifact-distribution correction methods for \emph{d} values, respectively.
The \code{ma_d} function is the master function for meta-analyses of \emph{d} values - it facilitates the computation of bare-bones, artifact-distribution, and individual-correction meta-analyses of correlations for any number of group-wise contrasts and any number of dependent variables.
When artifact-distribution meta-analyses are performed, \code{ma_d} will automatically extract the artifact information from a database and organize it into the requested type of artifact distribution object (i.e., either Taylor series or interactive artifact distributions).
\code{ma_d} is also equipped with the capability to clean databases containing inconsistently recorded artifact data, impute missing artifacts (when individual-correction meta-analyses are requested), and remove dependency among samples by forming composites or averaging effect sizes and artifacts.
The automatic compositing features in \code{ma_d} are employed when \code{sample_id}s and/or construct names are provided.
}
\details{
The options for \code{correction_method} are:
\itemize{
\item{"auto"}{\cr Automatic selection of the most appropriate correction procedure, based on the available artifacts and the logical arguments provided to the function. (default)}
\item{"meas"}{\cr Correction for measurement error only.}
\item{"uvdrr"}{\cr Correction for univariate direct range restriction (i.e., Case II). The choice of which variable to correct for range restriction is made using the \code{correct_rr_x} and \code{correct_rr_y} arguments.}
\item{"uvirr"}{\cr Correction for univariate indirect range restriction (i.e., Case IV). The choice of which variable to correct for range restriction is made using the \code{correct_rr_x} and \code{correct_rr_y} arguments.}
\item{"bvdrr"}{\cr Correction for bivariate direct range restriction. Use with caution: This correction is an approximation only and is known to have a positive bias.}
\item{"bvirr"}{\cr Correction for bivariate indirect range restriction (i.e., Case V).}
\item{"rbOrig"}{\cr Not recommended: Raju and Burke's version of the correction for direct range restriction, applied interactively. We recommend using "uvdrr" instead.}
\item{"rbAdj"}{\cr Not recommended: Raju and Burke's version of the correction for direct range restriction, applied interactively. Adjusted to account for range restriction in the reliability of the Y variable. We recommend using "uvdrr" instead.}
\item{"rb1Orig"}{\cr Not recommended: Raju and Burke's version of the correction for direct range restriction, applied using their TSA1 method. We recommend using "uvdrr" instead.}
\item{"rb1Adj"}{\cr Not recommended: Raju and Burke's version of the correction for direct range restriction, applied using their TSA1 method. Adjusted to account for range restriction in the reliability of the Y variable. We recommend using "uvdrr" instead.}
\item{"rb2Orig"}{\cr Not recommended: Raju and Burke's version of the correction for direct range restriction, applied using their TSA2 method. We recommend using "uvdrr" instead.}
\item{"rb2Adj"}{\cr Not recommended: Raju and Burke's version of the correction for direct range restriction, applied using their TSA2 method. Adjusted to account for range restriction in the reliability of the Y variable. We recommend using "uvdrr" instead.}
}
}
\section{Note}{

The difference between "rb" methods with the "orig" and "adj" suffixes is that the original does not account for the impact of range restriction on criterion reliabilities, whereas
the adjusted procedure attempts to estimate the applicant reliability information for the criterion. The "rb" procedures are included for posterity: We strongly recommend using
the "uvdrr" procedure to appropriately correct for univariate range restriction.
}

\examples{
### Demonstration of ma_d ###
## The 'ma_d' function can compute multi-construct bare-bones meta-analyses:
ma_d(d = d, n1 = n1, n2 = n2, construct_y = construct, data = data_d_meas_multi)

## It can also perform multiple individual-correction meta-analyses:
ma_d(ma_method = "ic", d = d, n1 = n1, n2 = n2, ryy = ryyi,
     construct_y = construct, data = data_d_meas_multi)

## And 'ma_d' can also curate artifact distributions and compute multiple
## artifact-distribution meta-analyses:
ma_d(ma_method = "ad", d = d, n1 = n1, n2 = n2,
     ryy = ryyi, correct_rr_y = FALSE,
     construct_y = construct, data = data_d_meas_multi)


### Demonstration of ma_d_bb ###
## Example meta-analyses using simulated data:
ma_d_bb(d = d, n1 = n1, n2 = n2,
        data = data_d_meas_multi[data_d_meas_multi$construct == "Y",])
ma_d_bb(d = d, n1 = n1, n2 = n2,
        data = data_d_meas_multi[data_d_meas_multi$construct == "Z",])


### Demonstration of ma_d_ic ###
## Example meta-analyses using simulated data:
ma_d_ic(d = d, n1 = n1, n2 = n2, ryy = ryyi, correct_rr_y = FALSE,
        data = data_d_meas_multi[data_d_meas_multi$construct == "Y",])
ma_d_ic(d = d, n1 = n1, n2 = n2, ryy = ryyi, correct_rr_y = FALSE,
        data = data_d_meas_multi[data_d_meas_multi$construct == "Z",])
}
\references{
Schmidt, F. L., & Hunter, J. E. (2015).
\emph{Methods of meta-analysis: Correcting error and bias in research findings (3rd ed.)}.
Thousand Oaks, California: SAGE Publications, Inc. Chapter 4.

Law, K. S., Schmidt, F. L., & Hunter, J. E. (1994).
Nonlinearity of range corrections in meta-analysis: Test of an improved procedure.
\emph{Journal of Applied Psychology, 79}(3), 425.

Dahlke, J. A., & Wiernik, B. M. (2020). Not restricted to selection research:
Accounting for indirect range restriction in organizational research.
\emph{Organizational Research Methods, 23}(4), 717–749. \doi{10.1177/1094428119859398}

Raju, N. S., & Burke, M. J. (1983). Two new procedures for studying validity generalization.
\emph{Journal of Applied Psychology, 68}(3), 382. \doi{10.1037/0021-9010.68.3.382}
}
