% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/provenance.R
\name{getPCA}
\alias{getPCA}
\title{Principal Component Analysis}
\usage{
getPCA(x, ...)
}
\arguments{
\item{x}{an object of class \code{HMdata}}

\item{...}{optional arguments to R's \code{princomp function}}
}
\value{
an object of class \code{PCA}
}
\description{
Performs PCA of compositional data using a centred logratio distance
}
\examples{
fname <- system.file("Major.csv",package="provenance")
Major <- read.HMdata(fname)
plot(getMDS(Major,classical=TRUE))
dev.new()
plot(getPCA(Major),asp=1)
print("This example demonstrates the equivalence of classical MDS and PCA")
}

