% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prompt-mem.R
\name{prompt_mem}
\alias{prompt_mem}
\alias{memory_usage}
\title{Example prompt that shows the current memory usage of the R process}
\usage{
prompt_mem(...)

memory_usage()
}
\arguments{
\item{...}{Ignored.}
}
\value{
\code{prompt_mem()} returns the formatted prompt in a string.

\code{memory_usage()} returns a list with entries:
\itemize{
\item \code{bytes}: the number of bytes of memory the current process uses.
This is the 'Resident Set Size', see \code{\link[ps:ps_memory_info]{ps::ps_memory_info()}}.
\item \code{formatted}: string that formats \code{bytes} nicely, with the appropriate
unit.
\item \code{total}: Total physical memory. See \code{\link[ps:ps_system_memory]{ps::ps_system_memory()}}.
\item \code{avail}: the memory that can be given instantly to processes
without the system going into swap. See \code{\link[ps:ps_system_memory]{ps::ps_system_memory()}}.
\item \code{percent}: Percentage of memory that is taken. See
\code{\link[ps:ps_system_memory]{ps::ps_system_memory()}}.
}
}
\description{
Example prompt that shows the current memory usage of the R process
}
\details{
\code{prompt_mem()} is a simple example prompt that shows the physical memory
allocated by the current process.

\code{memory_usage()} is a utility function that shows memory information
about the current R process and the system. You can use it to create a
custom prompt.
}
\examples{
\dontshow{if (ps::ps_is_supported()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
cat(prompt_mem())
\dontshow{\}) # examplesIf}
\dontshow{if (ps::ps_is_supported()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
memory_usage()
\dontshow{\}) # examplesIf}
}
\seealso{
Other example prompts: 
\code{\link{new_prompt_powerline}()},
\code{\link{prompt_devtools}()},
\code{\link{prompt_fancy}()},
\code{\link{prompt_git}()},
\code{\link{prompt_runtime}()},
\code{\link{prompt_status}()}
}
\concept{example prompts}
