% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VPC.r
\name{get_correlation_matrix}
\alias{get_correlation_matrix}
\alias{get_correlation_matrix.plcp_multi}
\title{Calculate the subject-level (ICC) correlations among time points}
\usage{
get_correlation_matrix(object)

\method{get_correlation_matrix}{plcp_multi}(object)
}
\arguments{
\item{object}{An object created by \code{\link{study_parameters}}}
}
\value{
A \code{n1} x \code{n1} \code{matrix} with the marginal subject-level
correlations between time points.
}
\description{
Calculate the subject-level (ICC) correlations among time points
}
\details{
The correlation between time point \eqn{T_i} and \eqn{T_{i+1}} within
the same subject is also called the intraclass correlation (ICC) at level two.
If the random slopes are non-zero this ICC change over time.
}
\examples{
paras <- study_parameters(n1 = 11,
                          n2 = 10,
                          n3 = 3,
                          T_end = 10,
                          icc_pre_subject = 0.5,
                          icc_pre_cluster = 0,
                          icc_slope = 0.05,
                          var_ratio = 0.03)
get_correlation_matrix(paras)
}
